/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassSpec;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterServiceClassSpecFluentImpl<A extends ClusterServiceClassSpecFluent<A>>
extends BaseFluent<A>
implements ClusterServiceClassSpecFluent<A> {
    private Boolean bindable;
    private Boolean bindingRetrievable;
    private String clusterServiceBrokerName;
    private Map<String, Object> defaultProvisionParameters;
    private String description;
    private String externalID;
    private Map<String, Object> externalMetadata;
    private String externalName;
    private Boolean planUpdatable;
    private List<String> requires = new ArrayList<String>();
    private List<String> tags = new ArrayList<String>();

    public ClusterServiceClassSpecFluentImpl() {
    }

    public ClusterServiceClassSpecFluentImpl(ClusterServiceClassSpec instance) {
        if (instance != null) {
            this.withBindable(instance.getBindable());
            this.withBindingRetrievable(instance.getBindingRetrievable());
            this.withClusterServiceBrokerName(instance.getClusterServiceBrokerName());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDescription(instance.getDescription());
            this.withExternalID(instance.getExternalID());
            this.withExternalMetadata(instance.getExternalMetadata());
            this.withExternalName(instance.getExternalName());
            this.withPlanUpdatable(instance.getPlanUpdatable());
            this.withRequires(instance.getRequires());
            this.withTags(instance.getTags());
        }
    }

    @Override
    public Boolean getBindable() {
        return this.bindable;
    }

    @Override
    public A withBindable(Boolean bindable) {
        this.bindable = bindable;
        return (A)this;
    }

    @Override
    public Boolean hasBindable() {
        return this.bindable != null;
    }

    @Override
    public Boolean getBindingRetrievable() {
        return this.bindingRetrievable;
    }

    @Override
    public A withBindingRetrievable(Boolean bindingRetrievable) {
        this.bindingRetrievable = bindingRetrievable;
        return (A)this;
    }

    @Override
    public Boolean hasBindingRetrievable() {
        return this.bindingRetrievable != null;
    }

    @Override
    public String getClusterServiceBrokerName() {
        return this.clusterServiceBrokerName;
    }

    @Override
    public A withClusterServiceBrokerName(String clusterServiceBrokerName) {
        this.clusterServiceBrokerName = clusterServiceBrokerName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterServiceBrokerName() {
        return this.clusterServiceBrokerName != null;
    }

    @Override
    public A addToDefaultProvisionParameters(String key, Object value) {
        if (this.defaultProvisionParameters == null && key != null && value != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.defaultProvisionParameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null && map != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.defaultProvisionParameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultProvisionParameters(String key) {
        if (this.defaultProvisionParameters == null) {
            return (A)this;
        }
        if (key != null && this.defaultProvisionParameters != null) {
            this.defaultProvisionParameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.defaultProvisionParameters == null) continue;
                this.defaultProvisionParameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getDefaultProvisionParameters() {
        return this.defaultProvisionParameters;
    }

    @Override
    public <K, V> A withDefaultProvisionParameters(Map<String, Object> defaultProvisionParameters) {
        this.defaultProvisionParameters = defaultProvisionParameters == null ? null : new LinkedHashMap<String, Object>(defaultProvisionParameters);
        return (A)this;
    }

    @Override
    public Boolean hasDefaultProvisionParameters() {
        return this.defaultProvisionParameters != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public A addToExternalMetadata(String key, Object value) {
        if (this.externalMetadata == null && key != null && value != null) {
            this.externalMetadata = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.externalMetadata.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExternalMetadata(Map<String, Object> map) {
        if (this.externalMetadata == null && map != null) {
            this.externalMetadata = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.externalMetadata.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalMetadata(String key) {
        if (this.externalMetadata == null) {
            return (A)this;
        }
        if (key != null && this.externalMetadata != null) {
            this.externalMetadata.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalMetadata(Map<String, Object> map) {
        if (this.externalMetadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.externalMetadata == null) continue;
                this.externalMetadata.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getExternalMetadata() {
        return this.externalMetadata;
    }

    @Override
    public <K, V> A withExternalMetadata(Map<String, Object> externalMetadata) {
        this.externalMetadata = externalMetadata == null ? null : new LinkedHashMap<String, Object>(externalMetadata);
        return (A)this;
    }

    @Override
    public Boolean hasExternalMetadata() {
        return this.externalMetadata != null;
    }

    @Override
    public String getExternalName() {
        return this.externalName;
    }

    @Override
    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)this;
    }

    @Override
    public Boolean hasExternalName() {
        return this.externalName != null;
    }

    @Override
    public Boolean getPlanUpdatable() {
        return this.planUpdatable;
    }

    @Override
    public A withPlanUpdatable(Boolean planUpdatable) {
        this.planUpdatable = planUpdatable;
        return (A)this;
    }

    @Override
    public Boolean hasPlanUpdatable() {
        return this.planUpdatable != null;
    }

    @Override
    public A addToRequires(int index, String item) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        this.requires.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequires(int index, String item) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        this.requires.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequires(String ... items) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        for (String item : items) {
            this.requires.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequires(Collection<String> items) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        for (String item : items) {
            this.requires.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequires(String ... items) {
        for (String item : items) {
            if (this.requires == null) continue;
            this.requires.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequires(Collection<String> items) {
        for (String item : items) {
            if (this.requires == null) continue;
            this.requires.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequires() {
        return this.requires;
    }

    @Override
    public String getRequire(int index) {
        return this.requires.get(index);
    }

    @Override
    public String getFirstRequire() {
        return this.requires.get(0);
    }

    @Override
    public String getLastRequire() {
        return this.requires.get(this.requires.size() - 1);
    }

    @Override
    public String getMatchingRequire(Predicate<String> predicate) {
        for (String item : this.requires) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRequire(Predicate<String> predicate) {
        for (String item : this.requires) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRequires(List<String> requires) {
        if (requires != null) {
            this.requires = new ArrayList<String>();
            for (String item : requires) {
                this.addToRequires(item);
            }
        } else {
            this.requires = null;
        }
        return (A)this;
    }

    @Override
    public A withRequires(String ... requires) {
        if (this.requires != null) {
            this.requires.clear();
            this._visitables.remove((Object)"requires");
        }
        if (requires != null) {
            for (String item : requires) {
                this.addToRequires(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequires() {
        return this.requires != null && !this.requires.isEmpty();
    }

    @Override
    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String ... items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<String> items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public String getTag(int index) {
        return this.tags.get(index);
    }

    @Override
    public String getFirstTag() {
        return this.tags.get(0);
    }

    @Override
    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    @Override
    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    @Override
    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterServiceClassSpecFluentImpl that = (ClusterServiceClassSpecFluentImpl)o;
        if (!Objects.equals(this.bindable, that.bindable)) {
            return false;
        }
        if (!Objects.equals(this.bindingRetrievable, that.bindingRetrievable)) {
            return false;
        }
        if (!Objects.equals(this.clusterServiceBrokerName, that.clusterServiceBrokerName)) {
            return false;
        }
        if (!Objects.equals(this.defaultProvisionParameters, that.defaultProvisionParameters)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals(this.externalMetadata, that.externalMetadata)) {
            return false;
        }
        if (!Objects.equals(this.externalName, that.externalName)) {
            return false;
        }
        if (!Objects.equals(this.planUpdatable, that.planUpdatable)) {
            return false;
        }
        if (!Objects.equals(this.requires, that.requires)) {
            return false;
        }
        return Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.bindable, this.bindingRetrievable, this.clusterServiceBrokerName, this.defaultProvisionParameters, this.description, this.externalID, this.externalMetadata, this.externalName, this.planUpdatable, this.requires, this.tags, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindable != null) {
            sb.append("bindable:");
            sb.append(this.bindable + ",");
        }
        if (this.bindingRetrievable != null) {
            sb.append("bindingRetrievable:");
            sb.append(this.bindingRetrievable + ",");
        }
        if (this.clusterServiceBrokerName != null) {
            sb.append("clusterServiceBrokerName:");
            sb.append(this.clusterServiceBrokerName + ",");
        }
        if (this.defaultProvisionParameters != null && !this.defaultProvisionParameters.isEmpty()) {
            sb.append("defaultProvisionParameters:");
            sb.append(this.defaultProvisionParameters + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.externalMetadata != null && !this.externalMetadata.isEmpty()) {
            sb.append("externalMetadata:");
            sb.append(this.externalMetadata + ",");
        }
        if (this.externalName != null) {
            sb.append("externalName:");
            sb.append(this.externalName + ",");
        }
        if (this.planUpdatable != null) {
            sb.append("planUpdatable:");
            sb.append(this.planUpdatable + ",");
        }
        if (this.requires != null && !this.requires.isEmpty()) {
            sb.append("requires:");
            sb.append(this.requires + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withBindable() {
        return this.withBindable(true);
    }

    @Override
    public A withBindingRetrievable() {
        return this.withBindingRetrievable(true);
    }

    @Override
    public A withPlanUpdatable() {
        return this.withPlanUpdatable(true);
    }
}

