/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceClass;
import io.fabric8.servicecatalog.api.model.ServiceClassFluent;
import io.fabric8.servicecatalog.api.model.ServiceClassSpec;
import io.fabric8.servicecatalog.api.model.ServiceClassSpecBuilder;
import io.fabric8.servicecatalog.api.model.ServiceClassSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceClassStatus;
import io.fabric8.servicecatalog.api.model.ServiceClassStatusBuilder;
import io.fabric8.servicecatalog.api.model.ServiceClassStatusFluentImpl;
import java.util.Objects;

public class ServiceClassFluentImpl<A extends ServiceClassFluent<A>>
extends BaseFluent<A>
implements ServiceClassFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServiceClassSpecBuilder spec;
    private ServiceClassStatusBuilder status;

    public ServiceClassFluentImpl() {
    }

    public ServiceClassFluentImpl(ServiceClass instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ServiceClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServiceClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServiceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ServiceClassSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ServiceClassSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ServiceClassSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ServiceClassSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ServiceClassFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ServiceClassFluent.SpecNested<A> withNewSpecLike(ServiceClassSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ServiceClassFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ServiceClassFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ServiceClassSpecBuilder().build());
    }

    @Override
    public ServiceClassFluent.SpecNested<A> editOrNewSpecLike(ServiceClassSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ServiceClassStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ServiceClassStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ServiceClassStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ServiceClassStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(Boolean removedFromBrokerCatalog) {
        return this.withStatus(new ServiceClassStatus(removedFromBrokerCatalog));
    }

    @Override
    public ServiceClassFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ServiceClassFluent.StatusNested<A> withNewStatusLike(ServiceClassStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ServiceClassFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ServiceClassFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ServiceClassStatusBuilder().build());
    }

    @Override
    public ServiceClassFluent.StatusNested<A> editOrNewStatusLike(ServiceClassStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceClassFluentImpl that = (ServiceClassFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ServiceClassStatusFluentImpl<ServiceClassFluent.StatusNested<N>>
    implements ServiceClassFluent.StatusNested<N>,
    Nested<N> {
        ServiceClassStatusBuilder builder;

        StatusNestedImpl(ServiceClassStatus item) {
            this.builder = new ServiceClassStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ServiceClassStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceClassFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ServiceClassSpecFluentImpl<ServiceClassFluent.SpecNested<N>>
    implements ServiceClassFluent.SpecNested<N>,
    Nested<N> {
        ServiceClassSpecBuilder builder;

        SpecNestedImpl(ServiceClassSpec item) {
            this.builder = new ServiceClassSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ServiceClassSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceClassFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceClassFluent.MetadataNested<N>>
    implements ServiceClassFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ServiceClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

