/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceInstanceList;
import io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceInstanceListFluentImpl<A extends ServiceInstanceListFluent<A>>
extends BaseFluent<A>
implements ServiceInstanceListFluent<A> {
    private String apiVersion;
    private ArrayList<ServiceInstanceBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ServiceInstanceListFluentImpl() {
    }

    public ServiceInstanceListFluentImpl(ServiceInstanceList instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, ServiceInstance item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, ServiceInstance item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ServiceInstance ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ServiceInstance> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceInstance ... items) {
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ServiceInstance> items) {
        for (ServiceInstance item : items) {
            ServiceInstanceBuilder builder = new ServiceInstanceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ServiceInstanceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ServiceInstanceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ServiceInstanceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceInstance> getItems() {
        return this.items != null ? ServiceInstanceListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<ServiceInstance> buildItems() {
        return this.items != null ? ServiceInstanceListFluentImpl.build(this.items) : null;
    }

    @Override
    public ServiceInstance buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ServiceInstance buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ServiceInstance buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ServiceInstance buildMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        for (ServiceInstanceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        for (ServiceInstanceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ServiceInstance> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ServiceInstance item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceInstance ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (ServiceInstance item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> addNewItemLike(ServiceInstance item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> setNewItemLike(int index, ServiceInstance item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceInstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceInstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceListFluentImpl that = (ServiceInstanceListFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends ServiceInstanceFluentImpl<ServiceInstanceListFluent.ItemsNested<N>>
    implements ServiceInstanceListFluent.ItemsNested<N>,
    Nested<N> {
        ServiceInstanceBuilder builder;
        int index;

        ItemsNestedImpl(int index, ServiceInstance item) {
            this.index = index;
            this.builder = new ServiceInstanceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceInstanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceInstanceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

