/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassFluent;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassSpec;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassSpecBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassStatus;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassStatusBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassStatusFluentImpl;
import java.util.Objects;

public class ClusterServiceClassFluentImpl<A extends ClusterServiceClassFluent<A>>
extends BaseFluent<A>
implements ClusterServiceClassFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ClusterServiceClassSpecBuilder spec;
    private ClusterServiceClassStatusBuilder status;

    public ClusterServiceClassFluentImpl() {
    }

    public ClusterServiceClassFluentImpl(ClusterServiceClass instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterServiceClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterServiceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterServiceClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterServiceClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterServiceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ClusterServiceClassSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ClusterServiceClassSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ClusterServiceClassSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ClusterServiceClassSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ClusterServiceClassFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ClusterServiceClassFluent.SpecNested<A> withNewSpecLike(ClusterServiceClassSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ClusterServiceClassFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ClusterServiceClassFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ClusterServiceClassSpecBuilder().build());
    }

    @Override
    public ClusterServiceClassFluent.SpecNested<A> editOrNewSpecLike(ClusterServiceClassSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ClusterServiceClassStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ClusterServiceClassStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ClusterServiceClassStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ClusterServiceClassStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(Boolean removedFromBrokerCatalog) {
        return this.withStatus(new ClusterServiceClassStatus(removedFromBrokerCatalog));
    }

    @Override
    public ClusterServiceClassFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ClusterServiceClassFluent.StatusNested<A> withNewStatusLike(ClusterServiceClassStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ClusterServiceClassFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ClusterServiceClassFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ClusterServiceClassStatusBuilder().build());
    }

    @Override
    public ClusterServiceClassFluent.StatusNested<A> editOrNewStatusLike(ClusterServiceClassStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterServiceClassFluentImpl that = (ClusterServiceClassFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ClusterServiceClassStatusFluentImpl<ClusterServiceClassFluent.StatusNested<N>>
    implements ClusterServiceClassFluent.StatusNested<N>,
    Nested<N> {
        ClusterServiceClassStatusBuilder builder;

        StatusNestedImpl(ClusterServiceClassStatus item) {
            this.builder = new ClusterServiceClassStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ClusterServiceClassStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServiceClassFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ClusterServiceClassSpecFluentImpl<ClusterServiceClassFluent.SpecNested<N>>
    implements ClusterServiceClassFluent.SpecNested<N>,
    Nested<N> {
        ClusterServiceClassSpecBuilder builder;

        SpecNestedImpl(ClusterServiceClassSpec item) {
            this.builder = new ClusterServiceClassSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ClusterServiceClassSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServiceClassFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterServiceClassFluent.MetadataNested<N>>
    implements ClusterServiceClassFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterServiceClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

