/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassFluentImpl;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterServiceClassListFluentImpl<A extends ClusterServiceClassListFluent<A>>
extends BaseFluent<A>
implements ClusterServiceClassListFluent<A> {
    private String apiVersion;
    private ArrayList<ClusterServiceClassBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ClusterServiceClassListFluentImpl() {
    }

    public ClusterServiceClassListFluentImpl(ClusterServiceClassList instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, ClusterServiceClass item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, ClusterServiceClass item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterServiceClass ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ClusterServiceClass item : items) {
            ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterServiceClass> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ClusterServiceClass item : items) {
            ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterServiceClass ... items) {
        for (ClusterServiceClass item : items) {
            ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterServiceClass> items) {
        for (ClusterServiceClass item : items) {
            ClusterServiceClassBuilder builder = new ClusterServiceClassBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterServiceClassBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterServiceClassBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ClusterServiceClassBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterServiceClass> getItems() {
        return this.items != null ? ClusterServiceClassListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<ClusterServiceClass> buildItems() {
        return this.items != null ? ClusterServiceClassListFluentImpl.build(this.items) : null;
    }

    @Override
    public ClusterServiceClass buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterServiceClass buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterServiceClass buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterServiceClass buildMatchingItem(Predicate<ClusterServiceClassBuilder> predicate) {
        for (ClusterServiceClassBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterServiceClassBuilder> predicate) {
        for (ClusterServiceClassBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterServiceClass> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ClusterServiceClass item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterServiceClass ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (ClusterServiceClass item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> addNewItemLike(ClusterServiceClass item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> setNewItemLike(int index, ClusterServiceClass item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterServiceClassListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterServiceClassBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterServiceClassListFluentImpl that = (ClusterServiceClassListFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends ClusterServiceClassFluentImpl<ClusterServiceClassListFluent.ItemsNested<N>>
    implements ClusterServiceClassListFluent.ItemsNested<N>,
    Nested<N> {
        ClusterServiceClassBuilder builder;
        int index;

        ItemsNestedImpl(int index, ClusterServiceClass item) {
            this.index = index;
            this.builder = new ClusterServiceClassBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterServiceClassBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServiceClassListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

