/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.servicecatalog.api.model.ServiceBindingCondition;
import io.fabric8.servicecatalog.api.model.ServiceBindingConditionBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingConditionFluent;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesState;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesStateBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesStateFluent;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceBindingStatusFluent<A extends ServiceBindingStatusFluent<A>>
extends BaseFluent<A> {
    private Boolean asyncOpInProgress;
    private ArrayList<ServiceBindingConditionBuilder> conditions = new ArrayList();
    private String currentOperation;
    private ServiceBindingPropertiesStateBuilder externalProperties;
    private ServiceBindingPropertiesStateBuilder inProgressProperties;
    private String lastOperation;
    private String operationStartTime;
    private Boolean orphanMitigationInProgress;
    private Long reconciledGeneration;
    private String unbindStatus;

    public ServiceBindingStatusFluent() {
    }

    public ServiceBindingStatusFluent(ServiceBindingStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBindingStatus instance) {
        ServiceBindingStatus serviceBindingStatus = instance = instance != null ? instance : new ServiceBindingStatus();
        if (instance != null) {
            this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
            this.withConditions(instance.getConditions());
            this.withCurrentOperation(instance.getCurrentOperation());
            this.withExternalProperties(instance.getExternalProperties());
            this.withInProgressProperties(instance.getInProgressProperties());
            this.withLastOperation(instance.getLastOperation());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
            this.withReconciledGeneration(instance.getReconciledGeneration());
            this.withUnbindStatus(instance.getUnbindStatus());
            this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
            this.withConditions(instance.getConditions());
            this.withCurrentOperation(instance.getCurrentOperation());
            this.withExternalProperties(instance.getExternalProperties());
            this.withInProgressProperties(instance.getInProgressProperties());
            this.withLastOperation(instance.getLastOperation());
            this.withOperationStartTime(instance.getOperationStartTime());
            this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
            this.withReconciledGeneration(instance.getReconciledGeneration());
            this.withUnbindStatus(instance.getUnbindStatus());
        }
    }

    public Boolean getAsyncOpInProgress() {
        return this.asyncOpInProgress;
    }

    public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
        this.asyncOpInProgress = asyncOpInProgress;
        return (A)((Object)this);
    }

    public boolean hasAsyncOpInProgress() {
        return this.asyncOpInProgress != null;
    }

    public A addToConditions(int index, ServiceBindingCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, ServiceBindingCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ServiceBindingCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<ServiceBindingCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ServiceBindingCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceBindingConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ServiceBindingConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServiceBindingCondition> buildConditions() {
        return this.conditions != null ? ServiceBindingStatusFluent.build(this.conditions) : null;
    }

    public ServiceBindingCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ServiceBindingCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ServiceBindingCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        for (ServiceBindingConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        for (ServiceBindingConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<ServiceBindingCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ServiceBindingCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ServiceBindingCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ServiceBindingCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ServiceBindingCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ServiceBindingCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public A withCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
        return (A)((Object)this);
    }

    public boolean hasCurrentOperation() {
        return this.currentOperation != null;
    }

    public ServiceBindingPropertiesState buildExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    public A withExternalProperties(ServiceBindingPropertiesState externalProperties) {
        this._visitables.get((Object)"externalProperties").remove((Object)this.externalProperties);
        if (externalProperties != null) {
            this.externalProperties = new ServiceBindingPropertiesStateBuilder(externalProperties);
            this._visitables.get((Object)"externalProperties").add(this.externalProperties);
        } else {
            this.externalProperties = null;
            this._visitables.get((Object)"externalProperties").remove((Object)this.externalProperties);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalProperties() {
        return this.externalProperties != null;
    }

    public ExternalPropertiesNested<A> withNewExternalProperties() {
        return new ExternalPropertiesNested(null);
    }

    public ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
        return new ExternalPropertiesNested(item);
    }

    public ExternalPropertiesNested<A> editExternalProperties() {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(null));
    }

    public ExternalPropertiesNested<A> editOrNewExternalProperties() {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(new ServiceBindingPropertiesStateBuilder().build()));
    }

    public ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
        return this.withNewExternalPropertiesLike(Optional.ofNullable(this.buildExternalProperties()).orElse(item));
    }

    public ServiceBindingPropertiesState buildInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    public A withInProgressProperties(ServiceBindingPropertiesState inProgressProperties) {
        this._visitables.get((Object)"inProgressProperties").remove((Object)this.inProgressProperties);
        if (inProgressProperties != null) {
            this.inProgressProperties = new ServiceBindingPropertiesStateBuilder(inProgressProperties);
            this._visitables.get((Object)"inProgressProperties").add(this.inProgressProperties);
        } else {
            this.inProgressProperties = null;
            this._visitables.get((Object)"inProgressProperties").remove((Object)this.inProgressProperties);
        }
        return (A)((Object)this);
    }

    public boolean hasInProgressProperties() {
        return this.inProgressProperties != null;
    }

    public InProgressPropertiesNested<A> withNewInProgressProperties() {
        return new InProgressPropertiesNested(null);
    }

    public InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
        return new InProgressPropertiesNested(item);
    }

    public InProgressPropertiesNested<A> editInProgressProperties() {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(null));
    }

    public InProgressPropertiesNested<A> editOrNewInProgressProperties() {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(new ServiceBindingPropertiesStateBuilder().build()));
    }

    public InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
        return this.withNewInProgressPropertiesLike(Optional.ofNullable(this.buildInProgressProperties()).orElse(item));
    }

    public String getLastOperation() {
        return this.lastOperation;
    }

    public A withLastOperation(String lastOperation) {
        this.lastOperation = lastOperation;
        return (A)((Object)this);
    }

    public boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    public String getOperationStartTime() {
        return this.operationStartTime;
    }

    public A withOperationStartTime(String operationStartTime) {
        this.operationStartTime = operationStartTime;
        return (A)((Object)this);
    }

    public boolean hasOperationStartTime() {
        return this.operationStartTime != null;
    }

    public Boolean getOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress;
    }

    public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
        this.orphanMitigationInProgress = orphanMitigationInProgress;
        return (A)((Object)this);
    }

    public boolean hasOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress != null;
    }

    public Long getReconciledGeneration() {
        return this.reconciledGeneration;
    }

    public A withReconciledGeneration(Long reconciledGeneration) {
        this.reconciledGeneration = reconciledGeneration;
        return (A)((Object)this);
    }

    public boolean hasReconciledGeneration() {
        return this.reconciledGeneration != null;
    }

    public String getUnbindStatus() {
        return this.unbindStatus;
    }

    public A withUnbindStatus(String unbindStatus) {
        this.unbindStatus = unbindStatus;
        return (A)((Object)this);
    }

    public boolean hasUnbindStatus() {
        return this.unbindStatus != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingStatusFluent that = (ServiceBindingStatusFluent)((Object)o);
        if (!Objects.equals(this.asyncOpInProgress, that.asyncOpInProgress)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentOperation, that.currentOperation)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalProperties, (Object)that.externalProperties)) {
            return false;
        }
        if (!Objects.equals((Object)this.inProgressProperties, (Object)that.inProgressProperties)) {
            return false;
        }
        if (!Objects.equals(this.lastOperation, that.lastOperation)) {
            return false;
        }
        if (!Objects.equals(this.operationStartTime, that.operationStartTime)) {
            return false;
        }
        if (!Objects.equals(this.orphanMitigationInProgress, that.orphanMitigationInProgress)) {
            return false;
        }
        if (!Objects.equals(this.reconciledGeneration, that.reconciledGeneration)) {
            return false;
        }
        return Objects.equals(this.unbindStatus, that.unbindStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asyncOpInProgress, this.conditions, this.currentOperation, this.externalProperties, this.inProgressProperties, this.lastOperation, this.operationStartTime, this.orphanMitigationInProgress, this.reconciledGeneration, this.unbindStatus, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.asyncOpInProgress != null) {
            sb.append("asyncOpInProgress:");
            sb.append(this.asyncOpInProgress + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentOperation != null) {
            sb.append("currentOperation:");
            sb.append(this.currentOperation + ",");
        }
        if (this.externalProperties != null) {
            sb.append("externalProperties:");
            sb.append((Object)((Object)this.externalProperties) + ",");
        }
        if (this.inProgressProperties != null) {
            sb.append("inProgressProperties:");
            sb.append((Object)((Object)this.inProgressProperties) + ",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append(this.lastOperation + ",");
        }
        if (this.operationStartTime != null) {
            sb.append("operationStartTime:");
            sb.append(this.operationStartTime + ",");
        }
        if (this.orphanMitigationInProgress != null) {
            sb.append("orphanMitigationInProgress:");
            sb.append(this.orphanMitigationInProgress + ",");
        }
        if (this.reconciledGeneration != null) {
            sb.append("reconciledGeneration:");
            sb.append(this.reconciledGeneration + ",");
        }
        if (this.unbindStatus != null) {
            sb.append("unbindStatus:");
            sb.append(this.unbindStatus);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAsyncOpInProgress() {
        return this.withAsyncOpInProgress(true);
    }

    public A withOrphanMitigationInProgress() {
        return this.withOrphanMitigationInProgress(true);
    }

    public class InProgressPropertiesNested<N>
    extends ServiceBindingPropertiesStateFluent<InProgressPropertiesNested<N>>
    implements Nested<N> {
        ServiceBindingPropertiesStateBuilder builder;

        InProgressPropertiesNested(ServiceBindingPropertiesState item) {
            this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingStatusFluent.this.withInProgressProperties(this.builder.build());
        }

        public N endInProgressProperties() {
            return this.and();
        }
    }

    public class ExternalPropertiesNested<N>
    extends ServiceBindingPropertiesStateFluent<ExternalPropertiesNested<N>>
    implements Nested<N> {
        ServiceBindingPropertiesStateBuilder builder;

        ExternalPropertiesNested(ServiceBindingPropertiesState item) {
            this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingStatusFluent.this.withExternalProperties(this.builder.build());
        }

        public N endExternalProperties() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ServiceBindingConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ServiceBindingConditionBuilder builder;
        int index;

        ConditionsNested(int index, ServiceBindingCondition item) {
            this.index = index;
            this.builder = new ServiceBindingConditionBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

