package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterBearerTokenAuthConfigBuilder extends ClusterBearerTokenAuthConfigFluent<ClusterBearerTokenAuthConfigBuilder> implements VisitableBuilder<ClusterBearerTokenAuthConfig,ClusterBearerTokenAuthConfigBuilder>{
  public ClusterBearerTokenAuthConfigBuilder() {
    this(new ClusterBearerTokenAuthConfig());
  }
  
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent) {
    this(fluent, new ClusterBearerTokenAuthConfig());
  }
  
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent,ClusterBearerTokenAuthConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterBearerTokenAuthConfigFluent<?> fluent;
  
  public ClusterBearerTokenAuthConfig build() {
    ClusterBearerTokenAuthConfig buildable = new ClusterBearerTokenAuthConfig(fluent.buildSecretRef());
    return buildable;
  }
  

}