package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterObjectReferenceBuilder extends ClusterObjectReferenceFluent<ClusterObjectReferenceBuilder> implements VisitableBuilder<ClusterObjectReference,ClusterObjectReferenceBuilder>{
  public ClusterObjectReferenceBuilder() {
    this(new ClusterObjectReference());
  }
  
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent) {
    this(fluent, new ClusterObjectReference());
  }
  
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent,ClusterObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterObjectReferenceBuilder(ClusterObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterObjectReferenceFluent<?> fluent;
  
  public ClusterObjectReference build() {
    ClusterObjectReference buildable = new ClusterObjectReference(fluent.getName());
    return buildable;
  }
  

}