package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServicePlanStatusBuilder extends ClusterServicePlanStatusFluent<ClusterServicePlanStatusBuilder> implements VisitableBuilder<ClusterServicePlanStatus,ClusterServicePlanStatusBuilder>{
  public ClusterServicePlanStatusBuilder() {
    this(new ClusterServicePlanStatus());
  }
  
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent) {
    this(fluent, new ClusterServicePlanStatus());
  }
  
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent,ClusterServicePlanStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServicePlanStatusFluent<?> fluent;
  
  public ClusterServicePlanStatus build() {
    ClusterServicePlanStatus buildable = new ClusterServicePlanStatus(fluent.getRemovedFromBrokerCatalog());
    return buildable;
  }
  

}