package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBindingConditionBuilder extends ServiceBindingConditionFluent<ServiceBindingConditionBuilder> implements VisitableBuilder<ServiceBindingCondition,ServiceBindingConditionBuilder>{
  public ServiceBindingConditionBuilder() {
    this(new ServiceBindingCondition());
  }
  
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent) {
    this(fluent, new ServiceBindingCondition());
  }
  
  public ServiceBindingConditionBuilder(ServiceBindingConditionFluent<?> fluent,ServiceBindingCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBindingConditionBuilder(ServiceBindingCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBindingConditionFluent<?> fluent;
  
  public ServiceBindingCondition build() {
    ServiceBindingCondition buildable = new ServiceBindingCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  

}