package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBrokerConditionBuilder extends ServiceBrokerConditionFluent<ServiceBrokerConditionBuilder> implements VisitableBuilder<ServiceBrokerCondition,ServiceBrokerConditionBuilder>{
  public ServiceBrokerConditionBuilder() {
    this(new ServiceBrokerCondition());
  }
  
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent) {
    this(fluent, new ServiceBrokerCondition());
  }
  
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent,ServiceBrokerCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBrokerConditionBuilder(ServiceBrokerCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBrokerConditionFluent<?> fluent;
  
  public ServiceBrokerCondition build() {
    ServiceBrokerCondition buildable = new ServiceBrokerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  

}