package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBrokerSpecBuilder extends ServiceBrokerSpecFluent<ServiceBrokerSpecBuilder> implements VisitableBuilder<ServiceBrokerSpec,ServiceBrokerSpecBuilder>{
  public ServiceBrokerSpecBuilder() {
    this(new ServiceBrokerSpec());
  }
  
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent) {
    this(fluent, new ServiceBrokerSpec());
  }
  
  public ServiceBrokerSpecBuilder(ServiceBrokerSpecFluent<?> fluent,ServiceBrokerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBrokerSpecBuilder(ServiceBrokerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBrokerSpecFluent<?> fluent;
  
  public ServiceBrokerSpec build() {
    ServiceBrokerSpec buildable = new ServiceBrokerSpec(fluent.buildAuthInfo(),fluent.getCaBundle(),fluent.buildCatalogRestrictions(),fluent.getInsecureSkipTLSVerify(),fluent.getRelistBehavior(),fluent.getRelistDuration(),fluent.getRelistRequests(),fluent.getUrl());
    return buildable;
  }
  

}