package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceClassBuilder extends ServiceClassFluent<ServiceClassBuilder> implements VisitableBuilder<ServiceClass,ServiceClassBuilder>{
  public ServiceClassBuilder() {
    this(new ServiceClass());
  }
  
  public ServiceClassBuilder(ServiceClassFluent<?> fluent) {
    this(fluent, new ServiceClass());
  }
  
  public ServiceClassBuilder(ServiceClassFluent<?> fluent,ServiceClass instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceClassBuilder(ServiceClass instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceClassFluent<?> fluent;
  
  public ServiceClass build() {
    ServiceClass buildable = new ServiceClass(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}