package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceClassSpecBuilder extends ServiceClassSpecFluent<ServiceClassSpecBuilder> implements VisitableBuilder<ServiceClassSpec,ServiceClassSpecBuilder>{
  public ServiceClassSpecBuilder() {
    this(new ServiceClassSpec());
  }
  
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent) {
    this(fluent, new ServiceClassSpec());
  }
  
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent,ServiceClassSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceClassSpecBuilder(ServiceClassSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceClassSpecFluent<?> fluent;
  
  public ServiceClassSpec build() {
    ServiceClassSpec buildable = new ServiceClassSpec(fluent.getBindable(),fluent.getBindingRetrievable(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getPlanUpdatable(),fluent.getRequires(),fluent.getServiceBrokerName(),fluent.getTags());
    return buildable;
  }
  

}