package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstanceListBuilder extends ServiceInstanceListFluent<ServiceInstanceListBuilder> implements VisitableBuilder<ServiceInstanceList,ServiceInstanceListBuilder>{
  public ServiceInstanceListBuilder() {
    this(new ServiceInstanceList());
  }
  
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent) {
    this(fluent, new ServiceInstanceList());
  }
  
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent,ServiceInstanceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstanceListBuilder(ServiceInstanceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstanceListFluent<?> fluent;
  
  public ServiceInstanceList build() {
    ServiceInstanceList buildable = new ServiceInstanceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}