/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.servicecatalog.api.model.CatalogRestrictions;
import io.fabric8.servicecatalog.api.model.CatalogRestrictionsBuilder;
import io.fabric8.servicecatalog.api.model.CatalogRestrictionsFluent;
import io.fabric8.servicecatalog.api.model.ServiceBrokerAuthInfo;
import io.fabric8.servicecatalog.api.model.ServiceBrokerAuthInfoBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBrokerAuthInfoFluent;
import io.fabric8.servicecatalog.api.model.ServiceBrokerSpec;
import java.util.Objects;
import java.util.Optional;

public class ServiceBrokerSpecFluent<A extends ServiceBrokerSpecFluent<A>>
extends BaseFluent<A> {
    private ServiceBrokerAuthInfoBuilder authInfo;
    private String caBundle;
    private CatalogRestrictionsBuilder catalogRestrictions;
    private Boolean insecureSkipTLSVerify;
    private String relistBehavior;
    private Duration relistDuration;
    private Long relistRequests;
    private String url;

    public ServiceBrokerSpecFluent() {
    }

    public ServiceBrokerSpecFluent(ServiceBrokerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBrokerSpec instance) {
        ServiceBrokerSpec serviceBrokerSpec = instance = instance != null ? instance : new ServiceBrokerSpec();
        if (instance != null) {
            this.withAuthInfo(instance.getAuthInfo());
            this.withCaBundle(instance.getCaBundle());
            this.withCatalogRestrictions(instance.getCatalogRestrictions());
            this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
            this.withRelistBehavior(instance.getRelistBehavior());
            this.withRelistDuration(instance.getRelistDuration());
            this.withRelistRequests(instance.getRelistRequests());
            this.withUrl(instance.getUrl());
            this.withAuthInfo(instance.getAuthInfo());
            this.withCaBundle(instance.getCaBundle());
            this.withCatalogRestrictions(instance.getCatalogRestrictions());
            this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
            this.withRelistBehavior(instance.getRelistBehavior());
            this.withRelistDuration(instance.getRelistDuration());
            this.withRelistRequests(instance.getRelistRequests());
            this.withUrl(instance.getUrl());
        }
    }

    public ServiceBrokerAuthInfo buildAuthInfo() {
        return this.authInfo != null ? this.authInfo.build() : null;
    }

    public A withAuthInfo(ServiceBrokerAuthInfo authInfo) {
        this._visitables.remove((Object)this.authInfo);
        if (authInfo != null) {
            this.authInfo = new ServiceBrokerAuthInfoBuilder(authInfo);
            this._visitables.get((Object)"authInfo").add(this.authInfo);
        } else {
            this.authInfo = null;
            this._visitables.get((Object)"authInfo").remove((Object)this.authInfo);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public AuthInfoNested<A> withNewAuthInfo() {
        return new AuthInfoNested(null);
    }

    public AuthInfoNested<A> withNewAuthInfoLike(ServiceBrokerAuthInfo item) {
        return new AuthInfoNested(item);
    }

    public AuthInfoNested<A> editAuthInfo() {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(null));
    }

    public AuthInfoNested<A> editOrNewAuthInfo() {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(new ServiceBrokerAuthInfoBuilder().build()));
    }

    public AuthInfoNested<A> editOrNewAuthInfoLike(ServiceBrokerAuthInfo item) {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(item));
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)((Object)this);
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public CatalogRestrictions buildCatalogRestrictions() {
        return this.catalogRestrictions != null ? this.catalogRestrictions.build() : null;
    }

    public A withCatalogRestrictions(CatalogRestrictions catalogRestrictions) {
        this._visitables.remove((Object)this.catalogRestrictions);
        if (catalogRestrictions != null) {
            this.catalogRestrictions = new CatalogRestrictionsBuilder(catalogRestrictions);
            this._visitables.get((Object)"catalogRestrictions").add(this.catalogRestrictions);
        } else {
            this.catalogRestrictions = null;
            this._visitables.get((Object)"catalogRestrictions").remove((Object)this.catalogRestrictions);
        }
        return (A)((Object)this);
    }

    public boolean hasCatalogRestrictions() {
        return this.catalogRestrictions != null;
    }

    public CatalogRestrictionsNested<A> withNewCatalogRestrictions() {
        return new CatalogRestrictionsNested(null);
    }

    public CatalogRestrictionsNested<A> withNewCatalogRestrictionsLike(CatalogRestrictions item) {
        return new CatalogRestrictionsNested(item);
    }

    public CatalogRestrictionsNested<A> editCatalogRestrictions() {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(null));
    }

    public CatalogRestrictionsNested<A> editOrNewCatalogRestrictions() {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(new CatalogRestrictionsBuilder().build()));
    }

    public CatalogRestrictionsNested<A> editOrNewCatalogRestrictionsLike(CatalogRestrictions item) {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(item));
    }

    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)((Object)this);
    }

    public boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    public String getRelistBehavior() {
        return this.relistBehavior;
    }

    public A withRelistBehavior(String relistBehavior) {
        this.relistBehavior = relistBehavior;
        return (A)((Object)this);
    }

    public boolean hasRelistBehavior() {
        return this.relistBehavior != null;
    }

    public Duration getRelistDuration() {
        return this.relistDuration;
    }

    public A withRelistDuration(Duration relistDuration) {
        this.relistDuration = relistDuration;
        return (A)((Object)this);
    }

    public boolean hasRelistDuration() {
        return this.relistDuration != null;
    }

    public Long getRelistRequests() {
        return this.relistRequests;
    }

    public A withRelistRequests(Long relistRequests) {
        this.relistRequests = relistRequests;
        return (A)((Object)this);
    }

    public boolean hasRelistRequests() {
        return this.relistRequests != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBrokerSpecFluent that = (ServiceBrokerSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.authInfo, (Object)that.authInfo)) {
            return false;
        }
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals((Object)this.catalogRestrictions, (Object)that.catalogRestrictions)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTLSVerify, that.insecureSkipTLSVerify)) {
            return false;
        }
        if (!Objects.equals(this.relistBehavior, that.relistBehavior)) {
            return false;
        }
        if (!Objects.equals(this.relistDuration, that.relistDuration)) {
            return false;
        }
        if (!Objects.equals(this.relistRequests, that.relistRequests)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authInfo, this.caBundle, this.catalogRestrictions, this.insecureSkipTLSVerify, this.relistBehavior, this.relistDuration, this.relistRequests, this.url, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authInfo != null) {
            sb.append("authInfo:");
            sb.append((Object)((Object)this.authInfo) + ",");
        }
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.catalogRestrictions != null) {
            sb.append("catalogRestrictions:");
            sb.append((Object)((Object)this.catalogRestrictions) + ",");
        }
        if (this.insecureSkipTLSVerify != null) {
            sb.append("insecureSkipTLSVerify:");
            sb.append(this.insecureSkipTLSVerify + ",");
        }
        if (this.relistBehavior != null) {
            sb.append("relistBehavior:");
            sb.append(this.relistBehavior + ",");
        }
        if (this.relistDuration != null) {
            sb.append("relistDuration:");
            sb.append(this.relistDuration + ",");
        }
        if (this.relistRequests != null) {
            sb.append("relistRequests:");
            sb.append(this.relistRequests + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipTLSVerify() {
        return this.withInsecureSkipTLSVerify(true);
    }

    public class CatalogRestrictionsNested<N>
    extends CatalogRestrictionsFluent<CatalogRestrictionsNested<N>>
    implements Nested<N> {
        CatalogRestrictionsBuilder builder;

        CatalogRestrictionsNested(CatalogRestrictions item) {
            this.builder = new CatalogRestrictionsBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBrokerSpecFluent.this.withCatalogRestrictions(this.builder.build());
        }

        public N endCatalogRestrictions() {
            return this.and();
        }
    }

    public class AuthInfoNested<N>
    extends ServiceBrokerAuthInfoFluent<AuthInfoNested<N>>
    implements Nested<N> {
        ServiceBrokerAuthInfoBuilder builder;

        AuthInfoNested(ServiceBrokerAuthInfo item) {
            this.builder = new ServiceBrokerAuthInfoBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBrokerSpecFluent.this.withAuthInfo(this.builder.build());
        }

        public N endAuthInfo() {
            return this.and();
        }
    }
}

