package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServiceBrokerSpecBuilder extends ClusterServiceBrokerSpecFluent<ClusterServiceBrokerSpecBuilder> implements VisitableBuilder<ClusterServiceBrokerSpec,ClusterServiceBrokerSpecBuilder>{
  public ClusterServiceBrokerSpecBuilder() {
    this(new ClusterServiceBrokerSpec());
  }
  
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent) {
    this(fluent, new ClusterServiceBrokerSpec());
  }
  
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent,ClusterServiceBrokerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServiceBrokerSpecFluent<?> fluent;
  
  public ClusterServiceBrokerSpec build() {
    ClusterServiceBrokerSpec buildable = new ClusterServiceBrokerSpec(fluent.buildAuthInfo(),fluent.getCaBundle(),fluent.buildCatalogRestrictions(),fluent.getInsecureSkipTLSVerify(),fluent.getRelistBehavior(),fluent.getRelistDuration(),fluent.getRelistRequests(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}