package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceInstanceBuilder extends ServiceInstanceFluent<ServiceInstanceBuilder> implements VisitableBuilder<ServiceInstance,ServiceInstanceBuilder>{
  public ServiceInstanceBuilder() {
    this(new ServiceInstance());
  }
  
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent) {
    this(fluent, new ServiceInstance());
  }
  
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent,ServiceInstance instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceInstanceBuilder(ServiceInstance instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceInstanceFluent<?> fluent;
  
  public ServiceInstance build() {
    ServiceInstance buildable = new ServiceInstance(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}