/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.server.mock.ServiceCatalogMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class ServiceCatalogServer
extends ExternalResource {
    protected ServiceCatalogMockServer mock;
    private ServiceCatalogClient client;
    private boolean https;
    private boolean crudMode;

    public ServiceCatalogServer() {
        this(true, false);
    }

    public ServiceCatalogServer(boolean https) {
        this(https, false);
    }

    public ServiceCatalogServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        this.mock = this.crudMode ? new ServiceCatalogMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(), true) : new ServiceCatalogMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createServiceCatalog();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public ServiceCatalogClient getServiceCatalogClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public MockWebServer getMockServer() {
        return this.mock.getServer();
    }
}

