/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.profile;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.PodUtils;
import io.fabric8.spring.cloud.kubernetes.StandardPodUtils;
import io.fabric8.spring.cloud.kubernetes.profile.KubernetesProfileApplicationListener;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public class KubernetesApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private final KubernetesProfileApplicationListener listener;
    private static final int ORDER = 100;

    public KubernetesApplicationContextInitializer() {
        this(new StandardPodUtils((KubernetesClient)new DefaultKubernetesClient()));
    }

    public KubernetesApplicationContextInitializer(PodUtils utils) {
        this(new KubernetesProfileApplicationListener(utils));
    }

    public KubernetesApplicationContextInitializer(KubernetesProfileApplicationListener listener) {
        this.listener = listener;
    }

    public int getOrder() {
        return 100;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.listener.addKubernetesProfile(applicationContext.getEnvironment());
    }
}

