/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import io.fabric8.spring.cloud.kubernetes.config.SecretsPropertySourceLocator;
import io.fabric8.spring.cloud.kubernetes.reload.ConfigReloadProperties;
import io.fabric8.spring.cloud.kubernetes.reload.ConfigurationChangeDetector;
import io.fabric8.spring.cloud.kubernetes.reload.ConfigurationUpdateStrategy;
import io.fabric8.spring.cloud.kubernetes.reload.EventBasedConfigurationChangeDetector;
import io.fabric8.spring.cloud.kubernetes.reload.PollingConfigurationChangeDetector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ConfigReloadProperties.class})
public class ConfigReloadAutoConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"})
    @ConditionalOnClass(value={RestartEndpoint.class, ContextRefresher.class})
    @EnableScheduling
    @EnableAsync
    protected static class ConfigReloadAutoConfigurationBeans {
        @Autowired
        private AbstractEnvironment environment;
        @Autowired
        private KubernetesClient kubernetesClient;
        @Autowired
        private ConfigMapPropertySourceLocator configMapPropertySourceLocator;
        @Autowired
        private SecretsPropertySourceLocator secretsPropertySourceLocator;

        protected ConfigReloadAutoConfigurationBeans() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationChangeDetector propertyChangeWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy) {
            switch (properties.getMode()) {
                case POLLING: {
                    return new PollingConfigurationChangeDetector(this.environment, properties, this.kubernetesClient, strategy, this.configMapPropertySourceLocator, this.secretsPropertySourceLocator);
                }
                case EVENT: {
                    return new EventBasedConfigurationChangeDetector(this.environment, properties, this.kubernetesClient, strategy, this.configMapPropertySourceLocator, this.secretsPropertySourceLocator);
                }
            }
            throw new IllegalStateException("Unsupported configuration reload mode: " + (Object)((Object)properties.getMode()));
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx, RestartEndpoint restarter, ContextRefresher refresher) {
            switch (properties.getStrategy()) {
                case RESTART_CONTEXT: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((RestartEndpoint)restarter).restart());
                }
                case REFRESH: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((ContextRefresher)refresher).refresh());
                }
                case SHUTDOWN: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((ConfigurableApplicationContext)ctx).close());
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + (Object)((Object)properties.getStrategy()));
        }
    }
}

