/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.tekton.pipeline.v1beta1.Param;
import io.fabric8.tekton.triggers.v1alpha1.WebhookInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class WebhookInterceptorFluent<A extends WebhookInterceptorFluent<A>>
extends BaseFluent<A> {
    private List<Param> header = new ArrayList<Param>();
    private ObjectReferenceBuilder objectRef;
    private String url;
    private Map<String, Object> additionalProperties;

    public WebhookInterceptorFluent() {
    }

    public WebhookInterceptorFluent(WebhookInterceptor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebhookInterceptor instance) {
        WebhookInterceptor webhookInterceptor = instance = instance != null ? instance : new WebhookInterceptor();
        if (instance != null) {
            this.withHeader(instance.getHeader());
            this.withObjectRef(instance.getObjectRef());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHeader(int index, Param item) {
        if (this.header == null) {
            this.header = new ArrayList<Param>();
        }
        this.header.add(index, item);
        return (A)((Object)this);
    }

    public A setToHeader(int index, Param item) {
        if (this.header == null) {
            this.header = new ArrayList<Param>();
        }
        this.header.set(index, item);
        return (A)((Object)this);
    }

    public A addToHeader(Param ... items) {
        if (this.header == null) {
            this.header = new ArrayList<Param>();
        }
        for (Param item : items) {
            this.header.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHeader(Collection<Param> items) {
        if (this.header == null) {
            this.header = new ArrayList<Param>();
        }
        for (Param item : items) {
            this.header.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHeader(Param ... items) {
        if (this.header == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            this.header.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHeader(Collection<Param> items) {
        if (this.header == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            this.header.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Param> getHeader() {
        return this.header;
    }

    public Param getHeader(int index) {
        return this.header.get(index);
    }

    public Param getFirstHeader() {
        return this.header.get(0);
    }

    public Param getLastHeader() {
        return this.header.get(this.header.size() - 1);
    }

    public Param getMatchingHeader(Predicate<Param> predicate) {
        for (Param item : this.header) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHeader(Predicate<Param> predicate) {
        for (Param item : this.header) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHeader(List<Param> header) {
        if (header != null) {
            this.header = new ArrayList<Param>();
            for (Param item : header) {
                this.addToHeader(item);
            }
        } else {
            this.header = null;
        }
        return (A)((Object)this);
    }

    public A withHeader(Param ... header) {
        if (this.header != null) {
            this.header.clear();
            this._visitables.remove((Object)"header");
        }
        if (header != null) {
            for (Param item : header) {
                this.addToHeader(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHeader() {
        return this.header != null && !this.header.isEmpty();
    }

    public ObjectReference buildObjectRef() {
        return this.objectRef != null ? this.objectRef.build() : null;
    }

    public A withObjectRef(ObjectReference objectRef) {
        this._visitables.remove((Object)"objectRef");
        if (objectRef != null) {
            this.objectRef = new ObjectReferenceBuilder(objectRef);
            this._visitables.get((Object)"objectRef").add(this.objectRef);
        } else {
            this.objectRef = null;
            this._visitables.get((Object)"objectRef").remove(this.objectRef);
        }
        return (A)((Object)this);
    }

    public boolean hasObjectRef() {
        return this.objectRef != null;
    }

    public ObjectRefNested<A> withNewObjectRef() {
        return new ObjectRefNested(null);
    }

    public ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
        return new ObjectRefNested(item);
    }

    public ObjectRefNested<A> editObjectRef() {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(null));
    }

    public ObjectRefNested<A> editOrNewObjectRef() {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookInterceptorFluent that = (WebhookInterceptorFluent)((Object)o);
        if (!Objects.equals(this.header, that.header)) {
            return false;
        }
        if (!Objects.equals(this.objectRef, that.objectRef)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.objectRef, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.header != null && !this.header.isEmpty()) {
            sb.append("header:");
            sb.append(this.header + ",");
        }
        if (this.objectRef != null) {
            sb.append("objectRef:");
            sb.append(this.objectRef + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ObjectRefNested<N>
    extends ObjectReferenceFluent<ObjectRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ObjectRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)WebhookInterceptorFluent.this.withObjectRef(this.builder.build());
        }

        public N endObjectRef() {
            return this.and();
        }
    }
}

