package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EventListenerTriggerGroupFluent<A extends EventListenerTriggerGroupFluent<A>> extends BaseFluent<A>{
  public EventListenerTriggerGroupFluent() {
  }
  
  public EventListenerTriggerGroupFluent(EventListenerTriggerGroup instance) {
    this.copyInstance(instance);
  }
  private ArrayList<TriggerInterceptorBuilder> interceptors = new ArrayList<TriggerInterceptorBuilder>();
  private String name;
  private EventListenerTriggerSelectorBuilder triggerSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EventListenerTriggerGroup instance) {
    instance = (instance != null ? instance : new EventListenerTriggerGroup());
    if (instance != null) {
          this.withInterceptors(instance.getInterceptors());
          this.withName(instance.getName());
          this.withTriggerSelector(instance.getTriggerSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToInterceptors(int index,TriggerInterceptor item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
    if (index < 0 || index >= interceptors.size()) { _visitables.get("interceptors").add(builder); interceptors.add(builder); } else { _visitables.get("interceptors").add(index, builder); interceptors.add(index, builder);}
    return (A)this;
  }
  
  public A setToInterceptors(int index,TriggerInterceptor item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
    if (index < 0 || index >= interceptors.size()) { _visitables.get("interceptors").add(builder); interceptors.add(builder); } else { _visitables.get("interceptors").set(index, builder); interceptors.set(index, builder);}
    return (A)this;
  }
  
  public A addToInterceptors(io.fabric8.tekton.triggers.v1beta1.TriggerInterceptor... items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
  }
  
  public A addAllToInterceptors(Collection<TriggerInterceptor> items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
  }
  
  public A removeFromInterceptors(io.fabric8.tekton.triggers.v1beta1.TriggerInterceptor... items) {
    if (this.interceptors == null) return (A)this;
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder); this.interceptors.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInterceptors(Collection<TriggerInterceptor> items) {
    if (this.interceptors == null) return (A)this;
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder); this.interceptors.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate) {
    if (interceptors == null) return (A) this;
    final Iterator<TriggerInterceptorBuilder> each = interceptors.iterator();
    final List visitables = _visitables.get("interceptors");
    while (each.hasNext()) {
      TriggerInterceptorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TriggerInterceptor> buildInterceptors() {
    return this.interceptors != null ? build(interceptors) : null;
  }
  
  public TriggerInterceptor buildInterceptor(int index) {
    return this.interceptors.get(index).build();
  }
  
  public TriggerInterceptor buildFirstInterceptor() {
    return this.interceptors.get(0).build();
  }
  
  public TriggerInterceptor buildLastInterceptor() {
    return this.interceptors.get(interceptors.size() - 1).build();
  }
  
  public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
      for (TriggerInterceptorBuilder item : interceptors) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
      for (TriggerInterceptorBuilder item : interceptors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInterceptors(List<TriggerInterceptor> interceptors) {
    if (this.interceptors != null) {
      this._visitables.get("interceptors").clear();
    }
    if (interceptors != null) {
        this.interceptors = new ArrayList();
        for (TriggerInterceptor item : interceptors) {
          this.addToInterceptors(item);
        }
    } else {
      this.interceptors = null;
    }
    return (A) this;
  }
  
  public A withInterceptors(io.fabric8.tekton.triggers.v1beta1.TriggerInterceptor... interceptors) {
    if (this.interceptors != null) {
        this.interceptors.clear();
        _visitables.remove("interceptors");
    }
    if (interceptors != null) {
      for (TriggerInterceptor item : interceptors) {
        this.addToInterceptors(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInterceptors() {
    return this.interceptors != null && !this.interceptors.isEmpty();
  }
  
  public InterceptorsNested<A> addNewInterceptor() {
    return new InterceptorsNested(-1, null);
  }
  
  public InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item) {
    return new InterceptorsNested(-1, item);
  }
  
  public InterceptorsNested<A> setNewInterceptorLike(int index,TriggerInterceptor item) {
    return new InterceptorsNested(index, item);
  }
  
  public InterceptorsNested<A> editInterceptor(int index) {
    if (interceptors.size() <= index) throw new RuntimeException("Can't edit interceptors. Index exceeds size.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  
  public InterceptorsNested<A> editFirstInterceptor() {
    if (interceptors.size() == 0) throw new RuntimeException("Can't edit first interceptors. The list is empty.");
    return setNewInterceptorLike(0, buildInterceptor(0));
  }
  
  public InterceptorsNested<A> editLastInterceptor() {
    int index = interceptors.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last interceptors. The list is empty.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  
  public InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<interceptors.size();i++) { 
    if (predicate.test(interceptors.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching interceptors. No match found.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public EventListenerTriggerSelector buildTriggerSelector() {
    return this.triggerSelector != null ? this.triggerSelector.build() : null;
  }
  
  public A withTriggerSelector(EventListenerTriggerSelector triggerSelector) {
    this._visitables.remove("triggerSelector");
    if (triggerSelector != null) {
        this.triggerSelector = new EventListenerTriggerSelectorBuilder(triggerSelector);
        this._visitables.get("triggerSelector").add(this.triggerSelector);
    } else {
        this.triggerSelector = null;
        this._visitables.get("triggerSelector").remove(this.triggerSelector);
    }
    return (A) this;
  }
  
  public boolean hasTriggerSelector() {
    return this.triggerSelector != null;
  }
  
  public TriggerSelectorNested<A> withNewTriggerSelector() {
    return new TriggerSelectorNested(null);
  }
  
  public TriggerSelectorNested<A> withNewTriggerSelectorLike(EventListenerTriggerSelector item) {
    return new TriggerSelectorNested(item);
  }
  
  public TriggerSelectorNested<A> editTriggerSelector() {
    return withNewTriggerSelectorLike(java.util.Optional.ofNullable(buildTriggerSelector()).orElse(null));
  }
  
  public TriggerSelectorNested<A> editOrNewTriggerSelector() {
    return withNewTriggerSelectorLike(java.util.Optional.ofNullable(buildTriggerSelector()).orElse(new EventListenerTriggerSelectorBuilder().build()));
  }
  
  public TriggerSelectorNested<A> editOrNewTriggerSelectorLike(EventListenerTriggerSelector item) {
    return withNewTriggerSelectorLike(java.util.Optional.ofNullable(buildTriggerSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventListenerTriggerGroupFluent that = (EventListenerTriggerGroupFluent) o;
    if (!java.util.Objects.equals(interceptors, that.interceptors)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(triggerSelector, that.triggerSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(interceptors,  name,  triggerSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (interceptors != null && !interceptors.isEmpty()) { sb.append("interceptors:"); sb.append(interceptors + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (triggerSelector != null) { sb.append("triggerSelector:"); sb.append(triggerSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InterceptorsNested<N> extends TriggerInterceptorFluent<InterceptorsNested<N>> implements Nested<N>{
    InterceptorsNested(int index,TriggerInterceptor item) {
      this.index = index;
      this.builder = new TriggerInterceptorBuilder(this, item);
    }
    TriggerInterceptorBuilder builder;
    int index;
    
    public N and() {
      return (N) EventListenerTriggerGroupFluent.this.setToInterceptors(index,builder.build());
    }
    
    public N endInterceptor() {
      return and();
    }
    
  
  }
  public class TriggerSelectorNested<N> extends EventListenerTriggerSelectorFluent<TriggerSelectorNested<N>> implements Nested<N>{
    TriggerSelectorNested(EventListenerTriggerSelector item) {
      this.builder = new EventListenerTriggerSelectorBuilder(this, item);
    }
    EventListenerTriggerSelectorBuilder builder;
    
    public N and() {
      return (N) EventListenerTriggerGroupFluent.this.withTriggerSelector(builder.build());
    }
    
    public N endTriggerSelector() {
      return and();
    }
    
  
  }

}