package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerConfigBuilder extends EventListenerConfigFluentImpl<EventListenerConfigBuilder> implements VisitableBuilder<EventListenerConfig,EventListenerConfigBuilder>{
  public EventListenerConfigBuilder() {
    this(false);
  }
  public EventListenerConfigBuilder(Boolean validationEnabled) {
    this(new EventListenerConfig(), validationEnabled);
  }
  public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerConfig(), validationEnabled);
  }
  public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,EventListenerConfig instance) {
    this(fluent, instance, false);
  }
  public EventListenerConfigBuilder(EventListenerConfigFluent<?> fluent,EventListenerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGeneratedName(instance.getGeneratedName()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerConfigBuilder(EventListenerConfig instance) {
    this(instance,false);
  }
  public EventListenerConfigBuilder(EventListenerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGeneratedName(instance.getGeneratedName()); 
    this.validationEnabled = validationEnabled; 
  }
  EventListenerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerConfig build() {
    EventListenerConfig buildable = new EventListenerConfig(fluent.getGeneratedName());
    return buildable;
  }
  
}