package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerSpecBuilder extends EventListenerSpecFluentImpl<EventListenerSpecBuilder> implements VisitableBuilder<EventListenerSpec,EventListenerSpecBuilder>{
  public EventListenerSpecBuilder() {
    this(false);
  }
  public EventListenerSpecBuilder(Boolean validationEnabled) {
    this(new EventListenerSpec(), validationEnabled);
  }
  public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerSpec(), validationEnabled);
  }
  public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,EventListenerSpec instance) {
    this(fluent, instance, false);
  }
  public EventListenerSpecBuilder(EventListenerSpecFluent<?> fluent,EventListenerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCloudEventURI(instance.getCloudEventURI()); 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withResources(instance.getResources()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withTriggerGroups(instance.getTriggerGroups()); 
    fluent.withTriggers(instance.getTriggers()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerSpecBuilder(EventListenerSpec instance) {
    this(instance,false);
  }
  public EventListenerSpecBuilder(EventListenerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCloudEventURI(instance.getCloudEventURI()); 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withResources(instance.getResources()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withTriggerGroups(instance.getTriggerGroups()); 
    this.withTriggers(instance.getTriggers()); 
    this.validationEnabled = validationEnabled; 
  }
  EventListenerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerSpec build() {
    EventListenerSpec buildable = new EventListenerSpec(fluent.getCloudEventURI(),fluent.getLabelSelector(),fluent.getNamespaceSelector(),fluent.getResources(),fluent.getServiceAccountName(),fluent.getTriggerGroups(),fluent.getTriggers());
    return buildable;
  }
  
}