package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventListenerSpecFluentImpl<A extends EventListenerSpecFluent<A>> extends BaseFluent<A> implements EventListenerSpecFluent<A>{
  public EventListenerSpecFluentImpl() {
  }
  public EventListenerSpecFluentImpl(EventListenerSpec instance) {
    this.withCloudEventURI(instance.getCloudEventURI()); 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withResources(instance.getResources()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withTriggerGroups(instance.getTriggerGroups()); 
    this.withTriggers(instance.getTriggers()); 
  }
  private String cloudEventURI;
  private LabelSelectorBuilder labelSelector;
  private NamespaceSelectorBuilder namespaceSelector;
  private ResourcesBuilder resources;
  private String serviceAccountName;
  private ArrayList<EventListenerTriggerGroupBuilder> triggerGroups = new ArrayList<EventListenerTriggerGroupBuilder>();
  private ArrayList<EventListenerTriggerBuilder> triggers = new ArrayList<EventListenerTriggerBuilder>();
  public String getCloudEventURI() {
    return this.cloudEventURI;
  }
  public A withCloudEventURI(String cloudEventURI) {
    this.cloudEventURI=cloudEventURI; return (A) this;
  }
  public Boolean hasCloudEventURI() {
    return this.cloudEventURI != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLabelSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public LabelSelector buildLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public A withLabelSelector(LabelSelector labelSelector) {
    _visitables.get("labelSelector").remove(this.labelSelector);
    if (labelSelector!=null){ this.labelSelector= new LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} else { this.labelSelector = null; _visitables.get("labelSelector").remove(this.labelSelector); } return (A) this;
  }
  public Boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public EventListenerSpecFluent.LabelSelectorNested<A> withNewLabelSelector() {
    return new EventListenerSpecFluentImpl.LabelSelectorNestedImpl();
  }
  public EventListenerSpecFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new EventListenerSpecFluentImpl.LabelSelectorNestedImpl(item);
  }
  public EventListenerSpecFluent.LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector());
  }
  public EventListenerSpecFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new LabelSelectorBuilder().build());
  }
  public EventListenerSpecFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public EventListenerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new EventListenerSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public EventListenerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new EventListenerSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public EventListenerSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public EventListenerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
  }
  public EventListenerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public Resources getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public Resources buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(Resources resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourcesBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public EventListenerSpecFluent.ResourcesNested<A> withNewResources() {
    return new EventListenerSpecFluentImpl.ResourcesNestedImpl();
  }
  public EventListenerSpecFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
    return new EventListenerSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public EventListenerSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public EventListenerSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourcesBuilder().build());
  }
  public EventListenerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public A addToTriggerGroups(Integer index,EventListenerTriggerGroup item) {
    if (this.triggerGroups == null) {this.triggerGroups = new ArrayList<EventListenerTriggerGroupBuilder>();}
    EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);_visitables.get("triggerGroups").add(index >= 0 ? index : _visitables.get("triggerGroups").size(), builder);this.triggerGroups.add(index >= 0 ? index : triggerGroups.size(), builder); return (A)this;
  }
  public A setToTriggerGroups(Integer index,EventListenerTriggerGroup item) {
    if (this.triggerGroups == null) {this.triggerGroups = new ArrayList<EventListenerTriggerGroupBuilder>();}
    EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);
    if (index < 0 || index >= _visitables.get("triggerGroups").size()) { _visitables.get("triggerGroups").add(builder); } else { _visitables.get("triggerGroups").set(index, builder);}
    if (index < 0 || index >= triggerGroups.size()) { triggerGroups.add(builder); } else { triggerGroups.set(index, builder);}
     return (A)this;
  }
  public A addToTriggerGroups(io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerGroup... items) {
    if (this.triggerGroups == null) {this.triggerGroups = new ArrayList<EventListenerTriggerGroupBuilder>();}
    for (EventListenerTriggerGroup item : items) {EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);_visitables.get("triggerGroups").add(builder);this.triggerGroups.add(builder);} return (A)this;
  }
  public A addAllToTriggerGroups(Collection<EventListenerTriggerGroup> items) {
    if (this.triggerGroups == null) {this.triggerGroups = new ArrayList<EventListenerTriggerGroupBuilder>();}
    for (EventListenerTriggerGroup item : items) {EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);_visitables.get("triggerGroups").add(builder);this.triggerGroups.add(builder);} return (A)this;
  }
  public A removeFromTriggerGroups(io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerGroup... items) {
    for (EventListenerTriggerGroup item : items) {EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);_visitables.get("triggerGroups").remove(builder);if (this.triggerGroups != null) {this.triggerGroups.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggerGroups(Collection<EventListenerTriggerGroup> items) {
    for (EventListenerTriggerGroup item : items) {EventListenerTriggerGroupBuilder builder = new EventListenerTriggerGroupBuilder(item);_visitables.get("triggerGroups").remove(builder);if (this.triggerGroups != null) {this.triggerGroups.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggerGroups(Predicate<EventListenerTriggerGroupBuilder> predicate) {
    if (triggerGroups == null) return (A) this;
    final Iterator<EventListenerTriggerGroupBuilder> each = triggerGroups.iterator();
    final List visitables = _visitables.get("triggerGroups");
    while (each.hasNext()) {
      EventListenerTriggerGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggerGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EventListenerTriggerGroup> getTriggerGroups() {
    return triggerGroups != null ? build(triggerGroups) : null;
  }
  public List<EventListenerTriggerGroup> buildTriggerGroups() {
    return triggerGroups != null ? build(triggerGroups) : null;
  }
  public EventListenerTriggerGroup buildTriggerGroup(Integer index) {
    return this.triggerGroups.get(index).build();
  }
  public EventListenerTriggerGroup buildFirstTriggerGroup() {
    return this.triggerGroups.get(0).build();
  }
  public EventListenerTriggerGroup buildLastTriggerGroup() {
    return this.triggerGroups.get(triggerGroups.size() - 1).build();
  }
  public EventListenerTriggerGroup buildMatchingTriggerGroup(Predicate<EventListenerTriggerGroupBuilder> predicate) {
    for (EventListenerTriggerGroupBuilder item: triggerGroups) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTriggerGroup(Predicate<EventListenerTriggerGroupBuilder> predicate) {
    for (EventListenerTriggerGroupBuilder item: triggerGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggerGroups(List<EventListenerTriggerGroup> triggerGroups) {
    if (this.triggerGroups != null) { _visitables.get("triggerGroups").removeAll(this.triggerGroups);}
    if (triggerGroups != null) {this.triggerGroups = new ArrayList(); for (EventListenerTriggerGroup item : triggerGroups){this.addToTriggerGroups(item);}} else { this.triggerGroups = null;} return (A) this;
  }
  public A withTriggerGroups(io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerGroup... triggerGroups) {
    if (this.triggerGroups != null) {this.triggerGroups.clear();}
    if (triggerGroups != null) {for (EventListenerTriggerGroup item :triggerGroups){ this.addToTriggerGroups(item);}} return (A) this;
  }
  public Boolean hasTriggerGroups() {
    return triggerGroups != null && !triggerGroups.isEmpty();
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> addNewTriggerGroup() {
    return new EventListenerSpecFluentImpl.TriggerGroupsNestedImpl();
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> addNewTriggerGroupLike(EventListenerTriggerGroup item) {
    return new EventListenerSpecFluentImpl.TriggerGroupsNestedImpl(-1, item);
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> setNewTriggerGroupLike(Integer index,EventListenerTriggerGroup item) {
    return new EventListenerSpecFluentImpl.TriggerGroupsNestedImpl(index, item);
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> editTriggerGroup(Integer index) {
    if (triggerGroups.size() <= index) throw new RuntimeException("Can't edit triggerGroups. Index exceeds size.");
    return setNewTriggerGroupLike(index, buildTriggerGroup(index));
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> editFirstTriggerGroup() {
    if (triggerGroups.size() == 0) throw new RuntimeException("Can't edit first triggerGroups. The list is empty.");
    return setNewTriggerGroupLike(0, buildTriggerGroup(0));
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> editLastTriggerGroup() {
    int index = triggerGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggerGroups. The list is empty.");
    return setNewTriggerGroupLike(index, buildTriggerGroup(index));
  }
  public EventListenerSpecFluent.TriggerGroupsNested<A> editMatchingTriggerGroup(Predicate<EventListenerTriggerGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggerGroups.size();i++) { 
    if (predicate.test(triggerGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggerGroups. No match found.");
    return setNewTriggerGroupLike(index, buildTriggerGroup(index));
  }
  public A addToTriggers(Integer index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
  }
  public A setToTriggers(Integer index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
    if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
    if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
     return (A)this;
  }
  public A addToTriggers(io.fabric8.tekton.triggers.v1beta1.EventListenerTrigger... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<EventListenerTrigger> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.tekton.triggers.v1beta1.EventListenerTrigger... items) {
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggers(Collection<EventListenerTrigger> items) {
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<EventListenerTriggerBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<EventListenerTriggerBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      EventListenerTriggerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EventListenerTrigger> getTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public List<EventListenerTrigger> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public EventListenerTrigger buildTrigger(Integer index) {
    return this.triggers.get(index).build();
  }
  public EventListenerTrigger buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public EventListenerTrigger buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public EventListenerTrigger buildMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    for (EventListenerTriggerBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    for (EventListenerTriggerBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(List<EventListenerTrigger> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
    if (triggers != null) {this.triggers = new ArrayList(); for (EventListenerTrigger item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.tekton.triggers.v1beta1.EventListenerTrigger... triggers) {
    if (this.triggers != null) {this.triggers.clear();}
    if (triggers != null) {for (EventListenerTrigger item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public Boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public EventListenerSpecFluent.TriggersNested<A> addNewTrigger() {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl();
  }
  public EventListenerSpecFluent.TriggersNested<A> addNewTriggerLike(EventListenerTrigger item) {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl(-1, item);
  }
  public EventListenerSpecFluent.TriggersNested<A> setNewTriggerLike(Integer index,EventListenerTrigger item) {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl(index, item);
  }
  public EventListenerSpecFluent.TriggersNested<A> editTrigger(Integer index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public EventListenerSpecFluent.TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public EventListenerSpecFluent.TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public EventListenerSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventListenerSpecFluentImpl that = (EventListenerSpecFluentImpl) o;
    if (cloudEventURI != null ? !cloudEventURI.equals(that.cloudEventURI) :that.cloudEventURI != null) return false;
    if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (triggerGroups != null ? !triggerGroups.equals(that.triggerGroups) :that.triggerGroups != null) return false;
    if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cloudEventURI,  labelSelector,  namespaceSelector,  resources,  serviceAccountName,  triggerGroups,  triggers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudEventURI != null) { sb.append("cloudEventURI:"); sb.append(cloudEventURI + ","); }
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (triggerGroups != null && !triggerGroups.isEmpty()) { sb.append("triggerGroups:"); sb.append(triggerGroups + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers); }
    sb.append("}");
    return sb.toString();
  }
  class LabelSelectorNestedImpl<N> extends LabelSelectorFluentImpl<EventListenerSpecFluent.LabelSelectorNested<N>> implements EventListenerSpecFluent.LabelSelectorNested<N>,Nested<N>{
    LabelSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<EventListenerSpecFluent.NamespaceSelectorNested<N>> implements EventListenerSpecFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new NamespaceSelectorBuilder(this);
    }
    NamespaceSelectorBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourcesFluentImpl<EventListenerSpecFluent.ResourcesNested<N>> implements EventListenerSpecFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(Resources item) {
      this.builder = new ResourcesBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourcesBuilder(this);
    }
    ResourcesBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class TriggerGroupsNestedImpl<N> extends EventListenerTriggerGroupFluentImpl<EventListenerSpecFluent.TriggerGroupsNested<N>> implements EventListenerSpecFluent.TriggerGroupsNested<N>,Nested<N>{
    TriggerGroupsNestedImpl(Integer index,EventListenerTriggerGroup item) {
      this.index = index;
      this.builder = new EventListenerTriggerGroupBuilder(this, item);
    }
    TriggerGroupsNestedImpl() {
      this.index = -1;
      this.builder = new EventListenerTriggerGroupBuilder(this);
    }
    EventListenerTriggerGroupBuilder builder;
    Integer index;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.setToTriggerGroups(index,builder.build());
    }
    public N endTriggerGroup() {
      return and();
    }
    
  }
  class TriggersNestedImpl<N> extends EventListenerTriggerFluentImpl<EventListenerSpecFluent.TriggersNested<N>> implements EventListenerSpecFluent.TriggersNested<N>,Nested<N>{
    TriggersNestedImpl(Integer index,EventListenerTrigger item) {
      this.index = index;
      this.builder = new EventListenerTriggerBuilder(this, item);
    }
    TriggersNestedImpl() {
      this.index = -1;
      this.builder = new EventListenerTriggerBuilder(this);
    }
    EventListenerTriggerBuilder builder;
    Integer index;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}