package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerTriggerGroupBuilder extends EventListenerTriggerGroupFluentImpl<EventListenerTriggerGroupBuilder> implements VisitableBuilder<EventListenerTriggerGroup,EventListenerTriggerGroupBuilder>{
  public EventListenerTriggerGroupBuilder() {
    this(false);
  }
  public EventListenerTriggerGroupBuilder(Boolean validationEnabled) {
    this(new EventListenerTriggerGroup(), validationEnabled);
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerTriggerGroup(), validationEnabled);
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroupFluent<?> fluent,EventListenerTriggerGroup instance) {
    this(fluent, instance, false);
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroupFluent<?> fluent,EventListenerTriggerGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withInterceptors(instance.getInterceptors()); 
    fluent.withName(instance.getName()); 
    fluent.withTriggerSelector(instance.getTriggerSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroup instance) {
    this(instance,false);
  }
  public EventListenerTriggerGroupBuilder(EventListenerTriggerGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withInterceptors(instance.getInterceptors()); 
    this.withName(instance.getName()); 
    this.withTriggerSelector(instance.getTriggerSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  EventListenerTriggerGroupFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerTriggerGroup build() {
    EventListenerTriggerGroup buildable = new EventListenerTriggerGroup(fluent.getInterceptors(),fluent.getName(),fluent.getTriggerSelector());
    return buildable;
  }
  
}