package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerTriggerSelectorBuilder extends EventListenerTriggerSelectorFluentImpl<EventListenerTriggerSelectorBuilder> implements VisitableBuilder<EventListenerTriggerSelector,EventListenerTriggerSelectorBuilder>{
  public EventListenerTriggerSelectorBuilder() {
    this(false);
  }
  public EventListenerTriggerSelectorBuilder(Boolean validationEnabled) {
    this(new EventListenerTriggerSelector(), validationEnabled);
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerTriggerSelector(), validationEnabled);
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelectorFluent<?> fluent,EventListenerTriggerSelector instance) {
    this(fluent, instance, false);
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelectorFluent<?> fluent,EventListenerTriggerSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelector instance) {
    this(instance,false);
  }
  public EventListenerTriggerSelectorBuilder(EventListenerTriggerSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  EventListenerTriggerSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerTriggerSelector build() {
    EventListenerTriggerSelector buildable = new EventListenerTriggerSelector(fluent.getLabelSelector(),fluent.getNamespaceSelector());
    return buildable;
  }
  
}