package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceSelectorBuilder extends NamespaceSelectorFluentImpl<NamespaceSelectorBuilder> implements VisitableBuilder<NamespaceSelector,NamespaceSelectorBuilder>{
  public NamespaceSelectorBuilder() {
    this(false);
  }
  public NamespaceSelectorBuilder(Boolean validationEnabled) {
    this(new NamespaceSelector(), validationEnabled);
  }
  public NamespaceSelectorBuilder(NamespaceSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceSelectorBuilder(NamespaceSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceSelector(), validationEnabled);
  }
  public NamespaceSelectorBuilder(NamespaceSelectorFluent<?> fluent,NamespaceSelector instance) {
    this(fluent, instance, false);
  }
  public NamespaceSelectorBuilder(NamespaceSelectorFluent<?> fluent,NamespaceSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchNames(instance.getMatchNames()); 
    this.validationEnabled = validationEnabled; 
  }
  public NamespaceSelectorBuilder(NamespaceSelector instance) {
    this(instance,false);
  }
  public NamespaceSelectorBuilder(NamespaceSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchNames(instance.getMatchNames()); 
    this.validationEnabled = validationEnabled; 
  }
  NamespaceSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceSelector build() {
    NamespaceSelector buildable = new NamespaceSelector(fluent.getMatchNames());
    return buildable;
  }
  
}