package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerBindingSpecBuilder extends TriggerBindingSpecFluentImpl<TriggerBindingSpecBuilder> implements VisitableBuilder<TriggerBindingSpec,TriggerBindingSpecBuilder>{
  public TriggerBindingSpecBuilder() {
    this(false);
  }
  public TriggerBindingSpecBuilder(Boolean validationEnabled) {
    this(new TriggerBindingSpec(), validationEnabled);
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerBindingSpec(), validationEnabled);
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,TriggerBindingSpec instance) {
    this(fluent, instance, false);
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpecFluent<?> fluent,TriggerBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withParams(instance.getParams()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpec instance) {
    this(instance,false);
  }
  public TriggerBindingSpecBuilder(TriggerBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withParams(instance.getParams()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerBindingSpec build() {
    TriggerBindingSpec buildable = new TriggerBindingSpec(fluent.getParams());
    return buildable;
  }
  
}