package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerInterceptorBuilder extends TriggerInterceptorFluentImpl<TriggerInterceptorBuilder> implements VisitableBuilder<TriggerInterceptor,TriggerInterceptorBuilder>{
  public TriggerInterceptorBuilder() {
    this(false);
  }
  public TriggerInterceptorBuilder(Boolean validationEnabled) {
    this(new TriggerInterceptor(), validationEnabled);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerInterceptor(), validationEnabled);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance) {
    this(fluent, instance, false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withParams(instance.getParams()); 
    fluent.withRef(instance.getRef()); 
    fluent.withWebhook(instance.getWebhook()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerInterceptorBuilder(TriggerInterceptor instance) {
    this(instance,false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withParams(instance.getParams()); 
    this.withRef(instance.getRef()); 
    this.withWebhook(instance.getWebhook()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerInterceptor build() {
    TriggerInterceptor buildable = new TriggerInterceptor(fluent.getName(),fluent.getParams(),fluent.getRef(),fluent.getWebhook());
    return buildable;
  }
  
}