package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerSpecBindingBuilder extends TriggerSpecBindingFluentImpl<TriggerSpecBindingBuilder> implements VisitableBuilder<TriggerSpecBinding,TriggerSpecBindingBuilder>{
  public TriggerSpecBindingBuilder() {
    this(false);
  }
  public TriggerSpecBindingBuilder(Boolean validationEnabled) {
    this(new TriggerSpecBinding(), validationEnabled);
  }
  public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerSpecBinding(), validationEnabled);
  }
  public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,TriggerSpecBinding instance) {
    this(fluent, instance, false);
  }
  public TriggerSpecBindingBuilder(TriggerSpecBindingFluent<?> fluent,TriggerSpecBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiversion(instance.getApiversion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withRef(instance.getRef()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerSpecBindingBuilder(TriggerSpecBinding instance) {
    this(instance,false);
  }
  public TriggerSpecBindingBuilder(TriggerSpecBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiversion(instance.getApiversion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withRef(instance.getRef()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerSpecBindingFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerSpecBinding build() {
    TriggerSpecBinding buildable = new TriggerSpecBinding(fluent.getApiversion(),fluent.getKind(),fluent.getName(),fluent.getRef(),fluent.getValue());
    return buildable;
  }
  
}