package io.fabric8.tekton.triggers.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.Param;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebhookInterceptorFluentImpl<A extends WebhookInterceptorFluent<A>> extends BaseFluent<A> implements WebhookInterceptorFluent<A>{
  public WebhookInterceptorFluentImpl() {
  }
  public WebhookInterceptorFluentImpl(WebhookInterceptor instance) {
    this.withHeader(instance.getHeader()); 
    this.withObjectRef(instance.getObjectRef()); 
    this.withUrl(instance.getUrl()); 
  }
  private List<Param> header = new ArrayList<Param>();
  private ObjectReferenceBuilder objectRef;
  private String url;
  public A addToHeader(Integer index,Param item) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    this.header.add(index, item);
    return (A)this;
  }
  public A setToHeader(Integer index,Param item) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    this.header.set(index, item); return (A)this;
  }
  public A addToHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    for (Param item : items) {this.header.add(item);} return (A)this;
  }
  public A addAllToHeader(Collection<Param> items) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    for (Param item : items) {this.header.add(item);} return (A)this;
  }
  public A removeFromHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
    for (Param item : items) {if (this.header!= null){ this.header.remove(item);}} return (A)this;
  }
  public A removeAllFromHeader(Collection<Param> items) {
    for (Param item : items) {if (this.header!= null){ this.header.remove(item);}} return (A)this;
  }
  public List<Param> getHeader() {
    return this.header;
  }
  public Param getHeader(Integer index) {
    return this.header.get(index);
  }
  public Param getFirstHeader() {
    return this.header.get(0);
  }
  public Param getLastHeader() {
    return this.header.get(header.size() - 1);
  }
  public Param getMatchingHeader(Predicate<Param> predicate) {
    for (Param item: header) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHeader(Predicate<Param> predicate) {
    for (Param item: header) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeader(List<Param> header) {
    if (header != null) {this.header = new ArrayList(); for (Param item : header){this.addToHeader(item);}} else { this.header = null;} return (A) this;
  }
  public A withHeader(io.fabric8.tekton.pipeline.v1beta1.Param... header) {
    if (this.header != null) {this.header.clear();}
    if (header != null) {for (Param item :header){ this.addToHeader(item);}} return (A) this;
  }
  public Boolean hasHeader() {
    return header != null && !header.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildObjectRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getObjectRef() {
    return this.objectRef!=null ?this.objectRef.build():null;
  }
  public ObjectReference buildObjectRef() {
    return this.objectRef!=null ?this.objectRef.build():null;
  }
  public A withObjectRef(ObjectReference objectRef) {
    _visitables.get("objectRef").remove(this.objectRef);
    if (objectRef!=null){ this.objectRef= new ObjectReferenceBuilder(objectRef); _visitables.get("objectRef").add(this.objectRef);} else { this.objectRef = null; _visitables.get("objectRef").remove(this.objectRef); } return (A) this;
  }
  public Boolean hasObjectRef() {
    return this.objectRef != null;
  }
  public WebhookInterceptorFluent.ObjectRefNested<A> withNewObjectRef() {
    return new WebhookInterceptorFluentImpl.ObjectRefNestedImpl();
  }
  public WebhookInterceptorFluent.ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
    return new WebhookInterceptorFluentImpl.ObjectRefNestedImpl(item);
  }
  public WebhookInterceptorFluent.ObjectRefNested<A> editObjectRef() {
    return withNewObjectRefLike(getObjectRef());
  }
  public WebhookInterceptorFluent.ObjectRefNested<A> editOrNewObjectRef() {
    return withNewObjectRefLike(getObjectRef() != null ? getObjectRef(): new ObjectReferenceBuilder().build());
  }
  public WebhookInterceptorFluent.ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
    return withNewObjectRefLike(getObjectRef() != null ? getObjectRef(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebhookInterceptorFluentImpl that = (WebhookInterceptorFluentImpl) o;
    if (header != null ? !header.equals(that.header) :that.header != null) return false;
    if (objectRef != null ? !objectRef.equals(that.objectRef) :that.objectRef != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(header,  objectRef,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (header != null && !header.isEmpty()) { sb.append("header:"); sb.append(header + ","); }
    if (objectRef != null) { sb.append("objectRef:"); sb.append(objectRef + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class ObjectRefNestedImpl<N> extends ObjectReferenceFluentImpl<WebhookInterceptorFluent.ObjectRefNested<N>> implements WebhookInterceptorFluent.ObjectRefNested<N>,Nested<N>{
    ObjectRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) WebhookInterceptorFluentImpl.this.withObjectRef(builder.build());
    }
    public N endObjectRef() {
      return and();
    }
    
  }
  
}