package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TriggerInterceptorFluent<A extends TriggerInterceptorFluent<A>> extends BaseFluent<A>{
  public TriggerInterceptorFluent() {
  }
  
  public TriggerInterceptorFluent(TriggerInterceptor instance) {
    this.copyInstance(instance);
  }
  private String name;
  private ArrayList<InterceptorParamsBuilder> params = new ArrayList<InterceptorParamsBuilder>();
  private InterceptorRefBuilder ref;
  private WebhookInterceptorBuilder webhook;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TriggerInterceptor instance) {
    instance = (instance != null ? instance : new TriggerInterceptor());
    if (instance != null) {
          this.withName(instance.getName());
          this.withParams(instance.getParams());
          this.withRef(instance.getRef());
          this.withWebhook(instance.getWebhook());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToParams(int index,InterceptorParams item) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  
  public A setToParams(int index,InterceptorParams item) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  
  public A addToParams(io.fabric8.tekton.triggers.v1beta1.InterceptorParams... items) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A addAllToParams(Collection<InterceptorParams> items) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A removeFromParams(io.fabric8.tekton.triggers.v1beta1.InterceptorParams... items) {
    if (this.params == null) return (A)this;
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParams(Collection<InterceptorParams> items) {
    if (this.params == null) return (A)this;
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParams(Predicate<InterceptorParamsBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<InterceptorParamsBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      InterceptorParamsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<InterceptorParams> buildParams() {
    return this.params != null ? build(params) : null;
  }
  
  public InterceptorParams buildParam(int index) {
    return this.params.get(index).build();
  }
  
  public InterceptorParams buildFirstParam() {
    return this.params.get(0).build();
  }
  
  public InterceptorParams buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  
  public InterceptorParams buildMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
      for (InterceptorParamsBuilder item : params) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
      for (InterceptorParamsBuilder item : params) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParams(List<InterceptorParams> params) {
    if (this.params != null) {
      this._visitables.get("params").clear();
    }
    if (params != null) {
        this.params = new ArrayList();
        for (InterceptorParams item : params) {
          this.addToParams(item);
        }
    } else {
      this.params = null;
    }
    return (A) this;
  }
  
  public A withParams(io.fabric8.tekton.triggers.v1beta1.InterceptorParams... params) {
    if (this.params != null) {
        this.params.clear();
        _visitables.remove("params");
    }
    if (params != null) {
      for (InterceptorParams item : params) {
        this.addToParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null && !this.params.isEmpty();
  }
  
  public A addNewParam(String name,Object value) {
    return (A)addToParams(new InterceptorParams(name, value));
  }
  
  public ParamsNested<A> addNewParam() {
    return new ParamsNested(-1, null);
  }
  
  public ParamsNested<A> addNewParamLike(InterceptorParams item) {
    return new ParamsNested(-1, item);
  }
  
  public ParamsNested<A> setNewParamLike(int index,InterceptorParams item) {
    return new ParamsNested(index, item);
  }
  
  public ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  
  public ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public InterceptorRef buildRef() {
    return this.ref != null ? this.ref.build() : null;
  }
  
  public A withRef(InterceptorRef ref) {
    this._visitables.remove("ref");
    if (ref != null) {
        this.ref = new InterceptorRefBuilder(ref);
        this._visitables.get("ref").add(this.ref);
    } else {
        this.ref = null;
        this._visitables.get("ref").remove(this.ref);
    }
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public A withNewRef(String apiVersion,String kind,String name) {
    return (A)withRef(new InterceptorRef(apiVersion, kind, name));
  }
  
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  
  public RefNested<A> withNewRefLike(InterceptorRef item) {
    return new RefNested(item);
  }
  
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new InterceptorRefBuilder().build()));
  }
  
  public RefNested<A> editOrNewRefLike(InterceptorRef item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  
  public WebhookInterceptor buildWebhook() {
    return this.webhook != null ? this.webhook.build() : null;
  }
  
  public A withWebhook(WebhookInterceptor webhook) {
    this._visitables.remove("webhook");
    if (webhook != null) {
        this.webhook = new WebhookInterceptorBuilder(webhook);
        this._visitables.get("webhook").add(this.webhook);
    } else {
        this.webhook = null;
        this._visitables.get("webhook").remove(this.webhook);
    }
    return (A) this;
  }
  
  public boolean hasWebhook() {
    return this.webhook != null;
  }
  
  public WebhookNested<A> withNewWebhook() {
    return new WebhookNested(null);
  }
  
  public WebhookNested<A> withNewWebhookLike(WebhookInterceptor item) {
    return new WebhookNested(item);
  }
  
  public WebhookNested<A> editWebhook() {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(null));
  }
  
  public WebhookNested<A> editOrNewWebhook() {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(new WebhookInterceptorBuilder().build()));
  }
  
  public WebhookNested<A> editOrNewWebhookLike(WebhookInterceptor item) {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerInterceptorFluent that = (TriggerInterceptorFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
    if (!java.util.Objects.equals(webhook, that.webhook)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  params,  ref,  webhook,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (webhook != null) { sb.append("webhook:"); sb.append(webhook + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParamsNested<N> extends InterceptorParamsFluent<ParamsNested<N>> implements Nested<N>{
    ParamsNested(int index,InterceptorParams item) {
      this.index = index;
      this.builder = new InterceptorParamsBuilder(this, item);
    }
    InterceptorParamsBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerInterceptorFluent.this.setToParams(index,builder.build());
    }
    
    public N endParam() {
      return and();
    }
    
  
  }
  public class RefNested<N> extends InterceptorRefFluent<RefNested<N>> implements Nested<N>{
    RefNested(InterceptorRef item) {
      this.builder = new InterceptorRefBuilder(this, item);
    }
    InterceptorRefBuilder builder;
    
    public N and() {
      return (N) TriggerInterceptorFluent.this.withRef(builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }
  public class WebhookNested<N> extends WebhookInterceptorFluent<WebhookNested<N>> implements Nested<N>{
    WebhookNested(WebhookInterceptor item) {
      this.builder = new WebhookInterceptorBuilder(this, item);
    }
    WebhookInterceptorBuilder builder;
    
    public N and() {
      return (N) TriggerInterceptorFluent.this.withWebhook(builder.build());
    }
    
    public N endWebhook() {
      return and();
    }
    
  
  }

}