package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineListBuilder extends PipelineListFluent<PipelineListBuilder> implements VisitableBuilder<PipelineList,PipelineListBuilder>{
  public PipelineListBuilder() {
    this(new PipelineList());
  }
  
  public PipelineListBuilder(PipelineListFluent<?> fluent) {
    this(fluent, new PipelineList());
  }
  
  public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineListBuilder(PipelineList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineListFluent<?> fluent;
  
  public PipelineList build() {
    PipelineList buildable = new PipelineList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}