package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineRefBuilder extends PipelineRefFluent<PipelineRefBuilder> implements VisitableBuilder<PipelineRef,PipelineRefBuilder>{
  public PipelineRefBuilder() {
    this(new PipelineRef());
  }
  
  public PipelineRefBuilder(PipelineRefFluent<?> fluent) {
    this(fluent, new PipelineRef());
  }
  
  public PipelineRefBuilder(PipelineRefFluent<?> fluent,PipelineRef instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineRefBuilder(PipelineRef instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineRefFluent<?> fluent;
  
  public PipelineRef build() {
    PipelineRef buildable = new PipelineRef(fluent.getApiVersion(),fluent.getName(),fluent.buildParams(),fluent.getResolver());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}