package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineRunBuilder extends PipelineRunFluent<PipelineRunBuilder> implements VisitableBuilder<PipelineRun,PipelineRunBuilder>{
  public PipelineRunBuilder() {
    this(new PipelineRun());
  }
  
  public PipelineRunBuilder(PipelineRunFluent<?> fluent) {
    this(fluent, new PipelineRun());
  }
  
  public PipelineRunBuilder(PipelineRunFluent<?> fluent,PipelineRun instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineRunBuilder(PipelineRun instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineRunFluent<?> fluent;
  
  public PipelineRun build() {
    PipelineRun buildable = new PipelineRun(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}