package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineRunSpecBuilder extends PipelineRunSpecFluent<PipelineRunSpecBuilder> implements VisitableBuilder<PipelineRunSpec,PipelineRunSpecBuilder>{
  public PipelineRunSpecBuilder() {
    this(new PipelineRunSpec());
  }
  
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent) {
    this(fluent, new PipelineRunSpec());
  }
  
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent,PipelineRunSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineRunSpecBuilder(PipelineRunSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineRunSpecFluent<?> fluent;
  
  public PipelineRunSpec build() {
    PipelineRunSpec buildable = new PipelineRunSpec(fluent.buildParams(),fluent.buildPipelineRef(),fluent.buildPipelineSpec(),fluent.getStatus(),fluent.buildTaskRunSpecs(),fluent.buildTaskRunTemplate(),fluent.buildTimeouts(),fluent.buildWorkspaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}