package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PipelineRunSpecFluent<A extends PipelineRunSpecFluent<A>> extends BaseFluent<A>{
  public PipelineRunSpecFluent() {
  }
  
  public PipelineRunSpecFluent(PipelineRunSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private PipelineRefBuilder pipelineRef;
  private PipelineSpecBuilder pipelineSpec;
  private String status;
  private ArrayList<PipelineTaskRunSpecBuilder> taskRunSpecs = new ArrayList<PipelineTaskRunSpecBuilder>();
  private PipelineTaskRunTemplateBuilder taskRunTemplate;
  private TimeoutFieldsBuilder timeouts;
  private ArrayList<WorkspaceBindingBuilder> workspaces = new ArrayList<WorkspaceBindingBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PipelineRunSpec instance) {
    instance = (instance != null ? instance : new PipelineRunSpec());
    if (instance != null) {
          this.withParams(instance.getParams());
          this.withPipelineRef(instance.getPipelineRef());
          this.withPipelineSpec(instance.getPipelineSpec());
          this.withStatus(instance.getStatus());
          this.withTaskRunSpecs(instance.getTaskRunSpecs());
          this.withTaskRunTemplate(instance.getTaskRunTemplate());
          this.withTimeouts(instance.getTimeouts());
          this.withWorkspaces(instance.getWorkspaces());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  
  public A addToParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParams(Collection<Param> items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Param> buildParams() {
    return this.params != null ? build(params) : null;
  }
  
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParams(List<Param> params) {
    if (this.params != null) {
      this._visitables.get("params").clear();
    }
    if (params != null) {
        this.params = new ArrayList();
        for (Param item : params) {
          this.addToParams(item);
        }
    } else {
      this.params = null;
    }
    return (A) this;
  }
  
  public A withParams(io.fabric8.tekton.pipeline.v1.Param... params) {
    if (this.params != null) {
        this.params.clear();
        _visitables.remove("params");
    }
    if (params != null) {
      for (Param item : params) {
        this.addToParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null && !this.params.isEmpty();
  }
  
  public ParamsNested<A> addNewParam() {
    return new ParamsNested(-1, null);
  }
  
  public ParamsNested<A> addNewParamLike(Param item) {
    return new ParamsNested(-1, item);
  }
  
  public ParamsNested<A> setNewParamLike(int index,Param item) {
    return new ParamsNested(index, item);
  }
  
  public ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  
  public ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public PipelineRef buildPipelineRef() {
    return this.pipelineRef != null ? this.pipelineRef.build() : null;
  }
  
  public A withPipelineRef(PipelineRef pipelineRef) {
    this._visitables.remove("pipelineRef");
    if (pipelineRef != null) {
        this.pipelineRef = new PipelineRefBuilder(pipelineRef);
        this._visitables.get("pipelineRef").add(this.pipelineRef);
    } else {
        this.pipelineRef = null;
        this._visitables.get("pipelineRef").remove(this.pipelineRef);
    }
    return (A) this;
  }
  
  public boolean hasPipelineRef() {
    return this.pipelineRef != null;
  }
  
  public PipelineRefNested<A> withNewPipelineRef() {
    return new PipelineRefNested(null);
  }
  
  public PipelineRefNested<A> withNewPipelineRefLike(PipelineRef item) {
    return new PipelineRefNested(item);
  }
  
  public PipelineRefNested<A> editPipelineRef() {
    return withNewPipelineRefLike(java.util.Optional.ofNullable(buildPipelineRef()).orElse(null));
  }
  
  public PipelineRefNested<A> editOrNewPipelineRef() {
    return withNewPipelineRefLike(java.util.Optional.ofNullable(buildPipelineRef()).orElse(new PipelineRefBuilder().build()));
  }
  
  public PipelineRefNested<A> editOrNewPipelineRefLike(PipelineRef item) {
    return withNewPipelineRefLike(java.util.Optional.ofNullable(buildPipelineRef()).orElse(item));
  }
  
  public PipelineSpec buildPipelineSpec() {
    return this.pipelineSpec != null ? this.pipelineSpec.build() : null;
  }
  
  public A withPipelineSpec(PipelineSpec pipelineSpec) {
    this._visitables.remove("pipelineSpec");
    if (pipelineSpec != null) {
        this.pipelineSpec = new PipelineSpecBuilder(pipelineSpec);
        this._visitables.get("pipelineSpec").add(this.pipelineSpec);
    } else {
        this.pipelineSpec = null;
        this._visitables.get("pipelineSpec").remove(this.pipelineSpec);
    }
    return (A) this;
  }
  
  public boolean hasPipelineSpec() {
    return this.pipelineSpec != null;
  }
  
  public PipelineSpecNested<A> withNewPipelineSpec() {
    return new PipelineSpecNested(null);
  }
  
  public PipelineSpecNested<A> withNewPipelineSpecLike(PipelineSpec item) {
    return new PipelineSpecNested(item);
  }
  
  public PipelineSpecNested<A> editPipelineSpec() {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(null));
  }
  
  public PipelineSpecNested<A> editOrNewPipelineSpec() {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(new PipelineSpecBuilder().build()));
  }
  
  public PipelineSpecNested<A> editOrNewPipelineSpecLike(PipelineSpec item) {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(item));
  }
  
  public String getStatus() {
    return this.status;
  }
  
  public A withStatus(String status) {
    this.status = status;
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public A addToTaskRunSpecs(int index,PipelineTaskRunSpec item) {
    if (this.taskRunSpecs == null) {this.taskRunSpecs = new ArrayList<PipelineTaskRunSpecBuilder>();}
    PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);
    if (index < 0 || index >= taskRunSpecs.size()) { _visitables.get("taskRunSpecs").add(builder); taskRunSpecs.add(builder); } else { _visitables.get("taskRunSpecs").add(index, builder); taskRunSpecs.add(index, builder);}
    return (A)this;
  }
  
  public A setToTaskRunSpecs(int index,PipelineTaskRunSpec item) {
    if (this.taskRunSpecs == null) {this.taskRunSpecs = new ArrayList<PipelineTaskRunSpecBuilder>();}
    PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);
    if (index < 0 || index >= taskRunSpecs.size()) { _visitables.get("taskRunSpecs").add(builder); taskRunSpecs.add(builder); } else { _visitables.get("taskRunSpecs").set(index, builder); taskRunSpecs.set(index, builder);}
    return (A)this;
  }
  
  public A addToTaskRunSpecs(io.fabric8.tekton.pipeline.v1.PipelineTaskRunSpec... items) {
    if (this.taskRunSpecs == null) {this.taskRunSpecs = new ArrayList<PipelineTaskRunSpecBuilder>();}
    for (PipelineTaskRunSpec item : items) {PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);_visitables.get("taskRunSpecs").add(builder);this.taskRunSpecs.add(builder);} return (A)this;
  }
  
  public A addAllToTaskRunSpecs(Collection<PipelineTaskRunSpec> items) {
    if (this.taskRunSpecs == null) {this.taskRunSpecs = new ArrayList<PipelineTaskRunSpecBuilder>();}
    for (PipelineTaskRunSpec item : items) {PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);_visitables.get("taskRunSpecs").add(builder);this.taskRunSpecs.add(builder);} return (A)this;
  }
  
  public A removeFromTaskRunSpecs(io.fabric8.tekton.pipeline.v1.PipelineTaskRunSpec... items) {
    if (this.taskRunSpecs == null) return (A)this;
    for (PipelineTaskRunSpec item : items) {PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);_visitables.get("taskRunSpecs").remove(builder); this.taskRunSpecs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTaskRunSpecs(Collection<PipelineTaskRunSpec> items) {
    if (this.taskRunSpecs == null) return (A)this;
    for (PipelineTaskRunSpec item : items) {PipelineTaskRunSpecBuilder builder = new PipelineTaskRunSpecBuilder(item);_visitables.get("taskRunSpecs").remove(builder); this.taskRunSpecs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTaskRunSpecs(Predicate<PipelineTaskRunSpecBuilder> predicate) {
    if (taskRunSpecs == null) return (A) this;
    final Iterator<PipelineTaskRunSpecBuilder> each = taskRunSpecs.iterator();
    final List visitables = _visitables.get("taskRunSpecs");
    while (each.hasNext()) {
      PipelineTaskRunSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PipelineTaskRunSpec> buildTaskRunSpecs() {
    return this.taskRunSpecs != null ? build(taskRunSpecs) : null;
  }
  
  public PipelineTaskRunSpec buildTaskRunSpec(int index) {
    return this.taskRunSpecs.get(index).build();
  }
  
  public PipelineTaskRunSpec buildFirstTaskRunSpec() {
    return this.taskRunSpecs.get(0).build();
  }
  
  public PipelineTaskRunSpec buildLastTaskRunSpec() {
    return this.taskRunSpecs.get(taskRunSpecs.size() - 1).build();
  }
  
  public PipelineTaskRunSpec buildMatchingTaskRunSpec(Predicate<PipelineTaskRunSpecBuilder> predicate) {
      for (PipelineTaskRunSpecBuilder item : taskRunSpecs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTaskRunSpec(Predicate<PipelineTaskRunSpecBuilder> predicate) {
      for (PipelineTaskRunSpecBuilder item : taskRunSpecs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTaskRunSpecs(List<PipelineTaskRunSpec> taskRunSpecs) {
    if (this.taskRunSpecs != null) {
      this._visitables.get("taskRunSpecs").clear();
    }
    if (taskRunSpecs != null) {
        this.taskRunSpecs = new ArrayList();
        for (PipelineTaskRunSpec item : taskRunSpecs) {
          this.addToTaskRunSpecs(item);
        }
    } else {
      this.taskRunSpecs = null;
    }
    return (A) this;
  }
  
  public A withTaskRunSpecs(io.fabric8.tekton.pipeline.v1.PipelineTaskRunSpec... taskRunSpecs) {
    if (this.taskRunSpecs != null) {
        this.taskRunSpecs.clear();
        _visitables.remove("taskRunSpecs");
    }
    if (taskRunSpecs != null) {
      for (PipelineTaskRunSpec item : taskRunSpecs) {
        this.addToTaskRunSpecs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTaskRunSpecs() {
    return this.taskRunSpecs != null && !this.taskRunSpecs.isEmpty();
  }
  
  public TaskRunSpecsNested<A> addNewTaskRunSpec() {
    return new TaskRunSpecsNested(-1, null);
  }
  
  public TaskRunSpecsNested<A> addNewTaskRunSpecLike(PipelineTaskRunSpec item) {
    return new TaskRunSpecsNested(-1, item);
  }
  
  public TaskRunSpecsNested<A> setNewTaskRunSpecLike(int index,PipelineTaskRunSpec item) {
    return new TaskRunSpecsNested(index, item);
  }
  
  public TaskRunSpecsNested<A> editTaskRunSpec(int index) {
    if (taskRunSpecs.size() <= index) throw new RuntimeException("Can't edit taskRunSpecs. Index exceeds size.");
    return setNewTaskRunSpecLike(index, buildTaskRunSpec(index));
  }
  
  public TaskRunSpecsNested<A> editFirstTaskRunSpec() {
    if (taskRunSpecs.size() == 0) throw new RuntimeException("Can't edit first taskRunSpecs. The list is empty.");
    return setNewTaskRunSpecLike(0, buildTaskRunSpec(0));
  }
  
  public TaskRunSpecsNested<A> editLastTaskRunSpec() {
    int index = taskRunSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last taskRunSpecs. The list is empty.");
    return setNewTaskRunSpecLike(index, buildTaskRunSpec(index));
  }
  
  public TaskRunSpecsNested<A> editMatchingTaskRunSpec(Predicate<PipelineTaskRunSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<taskRunSpecs.size();i++) { 
    if (predicate.test(taskRunSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching taskRunSpecs. No match found.");
    return setNewTaskRunSpecLike(index, buildTaskRunSpec(index));
  }
  
  public PipelineTaskRunTemplate buildTaskRunTemplate() {
    return this.taskRunTemplate != null ? this.taskRunTemplate.build() : null;
  }
  
  public A withTaskRunTemplate(PipelineTaskRunTemplate taskRunTemplate) {
    this._visitables.remove("taskRunTemplate");
    if (taskRunTemplate != null) {
        this.taskRunTemplate = new PipelineTaskRunTemplateBuilder(taskRunTemplate);
        this._visitables.get("taskRunTemplate").add(this.taskRunTemplate);
    } else {
        this.taskRunTemplate = null;
        this._visitables.get("taskRunTemplate").remove(this.taskRunTemplate);
    }
    return (A) this;
  }
  
  public boolean hasTaskRunTemplate() {
    return this.taskRunTemplate != null;
  }
  
  public TaskRunTemplateNested<A> withNewTaskRunTemplate() {
    return new TaskRunTemplateNested(null);
  }
  
  public TaskRunTemplateNested<A> withNewTaskRunTemplateLike(PipelineTaskRunTemplate item) {
    return new TaskRunTemplateNested(item);
  }
  
  public TaskRunTemplateNested<A> editTaskRunTemplate() {
    return withNewTaskRunTemplateLike(java.util.Optional.ofNullable(buildTaskRunTemplate()).orElse(null));
  }
  
  public TaskRunTemplateNested<A> editOrNewTaskRunTemplate() {
    return withNewTaskRunTemplateLike(java.util.Optional.ofNullable(buildTaskRunTemplate()).orElse(new PipelineTaskRunTemplateBuilder().build()));
  }
  
  public TaskRunTemplateNested<A> editOrNewTaskRunTemplateLike(PipelineTaskRunTemplate item) {
    return withNewTaskRunTemplateLike(java.util.Optional.ofNullable(buildTaskRunTemplate()).orElse(item));
  }
  
  public TimeoutFields buildTimeouts() {
    return this.timeouts != null ? this.timeouts.build() : null;
  }
  
  public A withTimeouts(TimeoutFields timeouts) {
    this._visitables.remove("timeouts");
    if (timeouts != null) {
        this.timeouts = new TimeoutFieldsBuilder(timeouts);
        this._visitables.get("timeouts").add(this.timeouts);
    } else {
        this.timeouts = null;
        this._visitables.get("timeouts").remove(this.timeouts);
    }
    return (A) this;
  }
  
  public boolean hasTimeouts() {
    return this.timeouts != null;
  }
  
  public TimeoutsNested<A> withNewTimeouts() {
    return new TimeoutsNested(null);
  }
  
  public TimeoutsNested<A> withNewTimeoutsLike(TimeoutFields item) {
    return new TimeoutsNested(item);
  }
  
  public TimeoutsNested<A> editTimeouts() {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(null));
  }
  
  public TimeoutsNested<A> editOrNewTimeouts() {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(new TimeoutFieldsBuilder().build()));
  }
  
  public TimeoutsNested<A> editOrNewTimeoutsLike(TimeoutFields item) {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(item));
  }
  
  public A addToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").add(index, builder); workspaces.add(index, builder);}
    return (A)this;
  }
  
  public A setToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").set(index, builder); workspaces.set(index, builder);}
    return (A)this;
  }
  
  public A addToWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  
  public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  
  public A removeFromWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... items) {
    if (this.workspaces == null) return (A)this;
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder); this.workspaces.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
    if (this.workspaces == null) return (A)this;
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder); this.workspaces.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
    if (workspaces == null) return (A) this;
    final Iterator<WorkspaceBindingBuilder> each = workspaces.iterator();
    final List visitables = _visitables.get("workspaces");
    while (each.hasNext()) {
      WorkspaceBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WorkspaceBinding> buildWorkspaces() {
    return this.workspaces != null ? build(workspaces) : null;
  }
  
  public WorkspaceBinding buildWorkspace(int index) {
    return this.workspaces.get(index).build();
  }
  
  public WorkspaceBinding buildFirstWorkspace() {
    return this.workspaces.get(0).build();
  }
  
  public WorkspaceBinding buildLastWorkspace() {
    return this.workspaces.get(workspaces.size() - 1).build();
  }
  
  public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
      for (WorkspaceBindingBuilder item : workspaces) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
      for (WorkspaceBindingBuilder item : workspaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWorkspaces(List<WorkspaceBinding> workspaces) {
    if (this.workspaces != null) {
      this._visitables.get("workspaces").clear();
    }
    if (workspaces != null) {
        this.workspaces = new ArrayList();
        for (WorkspaceBinding item : workspaces) {
          this.addToWorkspaces(item);
        }
    } else {
      this.workspaces = null;
    }
    return (A) this;
  }
  
  public A withWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... workspaces) {
    if (this.workspaces != null) {
        this.workspaces.clear();
        _visitables.remove("workspaces");
    }
    if (workspaces != null) {
      for (WorkspaceBinding item : workspaces) {
        this.addToWorkspaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWorkspaces() {
    return this.workspaces != null && !this.workspaces.isEmpty();
  }
  
  public WorkspacesNested<A> addNewWorkspace() {
    return new WorkspacesNested(-1, null);
  }
  
  public WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
    return new WorkspacesNested(-1, item);
  }
  
  public WorkspacesNested<A> setNewWorkspaceLike(int index,WorkspaceBinding item) {
    return new WorkspacesNested(index, item);
  }
  
  public WorkspacesNested<A> editWorkspace(int index) {
    if (workspaces.size() <= index) throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public WorkspacesNested<A> editFirstWorkspace() {
    if (workspaces.size() == 0) throw new RuntimeException("Can't edit first workspaces. The list is empty.");
    return setNewWorkspaceLike(0, buildWorkspace(0));
  }
  
  public WorkspacesNested<A> editLastWorkspace() {
    int index = workspaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last workspaces. The list is empty.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<workspaces.size();i++) { 
    if (predicate.test(workspaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching workspaces. No match found.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineRunSpecFluent that = (PipelineRunSpecFluent) o;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(pipelineRef, that.pipelineRef)) return false;
    if (!java.util.Objects.equals(pipelineSpec, that.pipelineSpec)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(taskRunSpecs, that.taskRunSpecs)) return false;
    if (!java.util.Objects.equals(taskRunTemplate, that.taskRunTemplate)) return false;
    if (!java.util.Objects.equals(timeouts, that.timeouts)) return false;
    if (!java.util.Objects.equals(workspaces, that.workspaces)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(params,  pipelineRef,  pipelineSpec,  status,  taskRunSpecs,  taskRunTemplate,  timeouts,  workspaces,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (pipelineRef != null) { sb.append("pipelineRef:"); sb.append(pipelineRef + ","); }
    if (pipelineSpec != null) { sb.append("pipelineSpec:"); sb.append(pipelineSpec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (taskRunSpecs != null && !taskRunSpecs.isEmpty()) { sb.append("taskRunSpecs:"); sb.append(taskRunSpecs + ","); }
    if (taskRunTemplate != null) { sb.append("taskRunTemplate:"); sb.append(taskRunTemplate + ","); }
    if (timeouts != null) { sb.append("timeouts:"); sb.append(timeouts + ","); }
    if (workspaces != null && !workspaces.isEmpty()) { sb.append("workspaces:"); sb.append(workspaces + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParamsNested<N> extends ParamFluent<ParamsNested<N>> implements Nested<N>{
    ParamsNested(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.setToParams(index,builder.build());
    }
    
    public N endParam() {
      return and();
    }
    
  
  }
  public class PipelineRefNested<N> extends PipelineRefFluent<PipelineRefNested<N>> implements Nested<N>{
    PipelineRefNested(PipelineRef item) {
      this.builder = new PipelineRefBuilder(this, item);
    }
    PipelineRefBuilder builder;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.withPipelineRef(builder.build());
    }
    
    public N endPipelineRef() {
      return and();
    }
    
  
  }
  public class PipelineSpecNested<N> extends PipelineSpecFluent<PipelineSpecNested<N>> implements Nested<N>{
    PipelineSpecNested(PipelineSpec item) {
      this.builder = new PipelineSpecBuilder(this, item);
    }
    PipelineSpecBuilder builder;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.withPipelineSpec(builder.build());
    }
    
    public N endPipelineSpec() {
      return and();
    }
    
  
  }
  public class TaskRunSpecsNested<N> extends PipelineTaskRunSpecFluent<TaskRunSpecsNested<N>> implements Nested<N>{
    TaskRunSpecsNested(int index,PipelineTaskRunSpec item) {
      this.index = index;
      this.builder = new PipelineTaskRunSpecBuilder(this, item);
    }
    PipelineTaskRunSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.setToTaskRunSpecs(index,builder.build());
    }
    
    public N endTaskRunSpec() {
      return and();
    }
    
  
  }
  public class TaskRunTemplateNested<N> extends PipelineTaskRunTemplateFluent<TaskRunTemplateNested<N>> implements Nested<N>{
    TaskRunTemplateNested(PipelineTaskRunTemplate item) {
      this.builder = new PipelineTaskRunTemplateBuilder(this, item);
    }
    PipelineTaskRunTemplateBuilder builder;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.withTaskRunTemplate(builder.build());
    }
    
    public N endTaskRunTemplate() {
      return and();
    }
    
  
  }
  public class TimeoutsNested<N> extends TimeoutFieldsFluent<TimeoutsNested<N>> implements Nested<N>{
    TimeoutsNested(TimeoutFields item) {
      this.builder = new TimeoutFieldsBuilder(this, item);
    }
    TimeoutFieldsBuilder builder;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.withTimeouts(builder.build());
    }
    
    public N endTimeouts() {
      return and();
    }
    
  
  }
  public class WorkspacesNested<N> extends WorkspaceBindingFluent<WorkspacesNested<N>> implements Nested<N>{
    WorkspacesNested(int index,WorkspaceBinding item) {
      this.index = index;
      this.builder = new WorkspaceBindingBuilder(this, item);
    }
    WorkspaceBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunSpecFluent.this.setToWorkspaces(index,builder.build());
    }
    
    public N endWorkspace() {
      return and();
    }
    
  
  }

}