package io.fabric8.tekton.pipeline.v1;

import java.lang.SuppressWarnings;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PipelineTaskRunTemplateFluent<A extends PipelineTaskRunTemplateFluent<A>> extends BaseFluent<A>{
  public PipelineTaskRunTemplateFluent() {
  }
  
  public PipelineTaskRunTemplateFluent(PipelineTaskRunTemplate instance) {
    this.copyInstance(instance);
  }
  private TemplateBuilder podTemplate;
  private String serviceAccountName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PipelineTaskRunTemplate instance) {
    instance = (instance != null ? instance : new PipelineTaskRunTemplate());
    if (instance != null) {
          this.withPodTemplate(instance.getPodTemplate());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Template buildPodTemplate() {
    return this.podTemplate != null ? this.podTemplate.build() : null;
  }
  
  public A withPodTemplate(Template podTemplate) {
    this._visitables.remove("podTemplate");
    if (podTemplate != null) {
        this.podTemplate = new TemplateBuilder(podTemplate);
        this._visitables.get("podTemplate").add(this.podTemplate);
    } else {
        this.podTemplate = null;
        this._visitables.get("podTemplate").remove(this.podTemplate);
    }
    return (A) this;
  }
  
  public boolean hasPodTemplate() {
    return this.podTemplate != null;
  }
  
  public PodTemplateNested<A> withNewPodTemplate() {
    return new PodTemplateNested(null);
  }
  
  public PodTemplateNested<A> withNewPodTemplateLike(Template item) {
    return new PodTemplateNested(item);
  }
  
  public PodTemplateNested<A> editPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(null));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(new TemplateBuilder().build()));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(item));
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineTaskRunTemplateFluent that = (PipelineTaskRunTemplateFluent) o;
    if (!java.util.Objects.equals(podTemplate, that.podTemplate)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(podTemplate,  serviceAccountName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (podTemplate != null) { sb.append("podTemplate:"); sb.append(podTemplate + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PodTemplateNested<N> extends TemplateFluent<PodTemplateNested<N>> implements Nested<N>{
    PodTemplateNested(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    
    public N and() {
      return (N) PipelineTaskRunTemplateFluent.this.withPodTemplate(builder.build());
    }
    
    public N endPodTemplate() {
      return and();
    }
    
  
  }

}