package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PropertySpecBuilder extends PropertySpecFluent<PropertySpecBuilder> implements VisitableBuilder<PropertySpec,PropertySpecBuilder>{
  public PropertySpecBuilder() {
    this(new PropertySpec());
  }
  
  public PropertySpecBuilder(PropertySpecFluent<?> fluent) {
    this(fluent, new PropertySpec());
  }
  
  public PropertySpecBuilder(PropertySpecFluent<?> fluent,PropertySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PropertySpecBuilder(PropertySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PropertySpecFluent<?> fluent;
  
  public PropertySpec build() {
    PropertySpec buildable = new PropertySpec(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}