package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SidecarStateFluent<A extends SidecarStateFluent<A>> extends BaseFluent<A>{
  public SidecarStateFluent() {
  }
  
  public SidecarStateFluent(SidecarState instance) {
    this.copyInstance(instance);
  }
  private String container;
  private String imageID;
  private String name;
  private ContainerStateRunning running;
  private ContainerStateTerminated terminated;
  private ContainerStateWaiting waiting;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SidecarState instance) {
    instance = (instance != null ? instance : new SidecarState());
    if (instance != null) {
          this.withContainer(instance.getContainer());
          this.withImageID(instance.getImageID());
          this.withName(instance.getName());
          this.withRunning(instance.getRunning());
          this.withTerminated(instance.getTerminated());
          this.withWaiting(instance.getWaiting());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getContainer() {
    return this.container;
  }
  
  public A withContainer(String container) {
    this.container = container;
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public String getImageID() {
    return this.imageID;
  }
  
  public A withImageID(String imageID) {
    this.imageID = imageID;
    return (A) this;
  }
  
  public boolean hasImageID() {
    return this.imageID != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public ContainerStateRunning getRunning() {
    return this.running;
  }
  
  public A withRunning(ContainerStateRunning running) {
    this.running = running;
    return (A) this;
  }
  
  public boolean hasRunning() {
    return this.running != null;
  }
  
  public A withNewRunning(String startedAt) {
    return (A)withRunning(new ContainerStateRunning(startedAt));
  }
  
  public ContainerStateTerminated getTerminated() {
    return this.terminated;
  }
  
  public A withTerminated(ContainerStateTerminated terminated) {
    this.terminated = terminated;
    return (A) this;
  }
  
  public boolean hasTerminated() {
    return this.terminated != null;
  }
  
  public ContainerStateWaiting getWaiting() {
    return this.waiting;
  }
  
  public A withWaiting(ContainerStateWaiting waiting) {
    this.waiting = waiting;
    return (A) this;
  }
  
  public boolean hasWaiting() {
    return this.waiting != null;
  }
  
  public A withNewWaiting(String message,String reason) {
    return (A)withWaiting(new ContainerStateWaiting(message, reason));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SidecarStateFluent that = (SidecarStateFluent) o;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(imageID, that.imageID)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(running, that.running)) return false;
    if (!java.util.Objects.equals(terminated, that.terminated)) return false;
    if (!java.util.Objects.equals(waiting, that.waiting)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(container,  imageID,  name,  running,  terminated,  waiting,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (terminated != null) { sb.append("terminated:"); sb.append(terminated + ","); }
    if (waiting != null) { sb.append("waiting:"); sb.append(waiting + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}