package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SkippedTaskBuilder extends SkippedTaskFluent<SkippedTaskBuilder> implements VisitableBuilder<SkippedTask,SkippedTaskBuilder>{
  public SkippedTaskBuilder() {
    this(new SkippedTask());
  }
  
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent) {
    this(fluent, new SkippedTask());
  }
  
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent,SkippedTask instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SkippedTaskBuilder(SkippedTask instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SkippedTaskFluent<?> fluent;
  
  public SkippedTask build() {
    SkippedTask buildable = new SkippedTask(fluent.getName(),fluent.getReason(),fluent.buildWhenExpressions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}