package io.fabric8.tekton.pipeline.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TaskRunDebugFluent<A extends TaskRunDebugFluent<A>> extends BaseFluent<A>{
  public TaskRunDebugFluent() {
  }
  
  public TaskRunDebugFluent(TaskRunDebug instance) {
    this.copyInstance(instance);
  }
  private List<String> breakpoint = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TaskRunDebug instance) {
    instance = (instance != null ? instance : new TaskRunDebug());
    if (instance != null) {
          this.withBreakpoint(instance.getBreakpoint());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBreakpoint(int index,String item) {
    if (this.breakpoint == null) {this.breakpoint = new ArrayList<String>();}
    this.breakpoint.add(index, item);
    return (A)this;
  }
  
  public A setToBreakpoint(int index,String item) {
    if (this.breakpoint == null) {this.breakpoint = new ArrayList<String>();}
    this.breakpoint.set(index, item); return (A)this;
  }
  
  public A addToBreakpoint(java.lang.String... items) {
    if (this.breakpoint == null) {this.breakpoint = new ArrayList<String>();}
    for (String item : items) {this.breakpoint.add(item);} return (A)this;
  }
  
  public A addAllToBreakpoint(Collection<String> items) {
    if (this.breakpoint == null) {this.breakpoint = new ArrayList<String>();}
    for (String item : items) {this.breakpoint.add(item);} return (A)this;
  }
  
  public A removeFromBreakpoint(java.lang.String... items) {
    if (this.breakpoint == null) return (A)this;
    for (String item : items) { this.breakpoint.remove(item);} return (A)this;
  }
  
  public A removeAllFromBreakpoint(Collection<String> items) {
    if (this.breakpoint == null) return (A)this;
    for (String item : items) { this.breakpoint.remove(item);} return (A)this;
  }
  
  public List<String> getBreakpoint() {
    return this.breakpoint;
  }
  
  public String getBreakpoint(int index) {
    return this.breakpoint.get(index);
  }
  
  public String getFirstBreakpoint() {
    return this.breakpoint.get(0);
  }
  
  public String getLastBreakpoint() {
    return this.breakpoint.get(breakpoint.size() - 1);
  }
  
  public String getMatchingBreakpoint(Predicate<String> predicate) {
      for (String item : breakpoint) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingBreakpoint(Predicate<String> predicate) {
      for (String item : breakpoint) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBreakpoint(List<String> breakpoint) {
    if (breakpoint != null) {
        this.breakpoint = new ArrayList();
        for (String item : breakpoint) {
          this.addToBreakpoint(item);
        }
    } else {
      this.breakpoint = null;
    }
    return (A) this;
  }
  
  public A withBreakpoint(java.lang.String... breakpoint) {
    if (this.breakpoint != null) {
        this.breakpoint.clear();
        _visitables.remove("breakpoint");
    }
    if (breakpoint != null) {
      for (String item : breakpoint) {
        this.addToBreakpoint(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBreakpoint() {
    return this.breakpoint != null && !this.breakpoint.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRunDebugFluent that = (TaskRunDebugFluent) o;
    if (!java.util.Objects.equals(breakpoint, that.breakpoint)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(breakpoint,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (breakpoint != null && !breakpoint.isEmpty()) { sb.append("breakpoint:"); sb.append(breakpoint + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}