package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TaskRunResultBuilder extends TaskRunResultFluent<TaskRunResultBuilder> implements VisitableBuilder<TaskRunResult,TaskRunResultBuilder>{
  public TaskRunResultBuilder() {
    this(new TaskRunResult());
  }
  
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent) {
    this(fluent, new TaskRunResult());
  }
  
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent,TaskRunResult instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TaskRunResultBuilder(TaskRunResult instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TaskRunResultFluent<?> fluent;
  
  public TaskRunResult build() {
    TaskRunResult buildable = new TaskRunResult(fluent.getName(),fluent.getType(),fluent.buildValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}