package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IncludeParamsFluent<A extends IncludeParamsFluent<A>> extends BaseFluent<A>{
  public IncludeParamsFluent() {
  }
  
  public IncludeParamsFluent(IncludeParams instance) {
    this.copyInstance(instance);
  }
  private String name;
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IncludeParams instance) {
    instance = (instance != null ? instance : new IncludeParams());
    if (instance != null) {
          this.withName(instance.getName());
          this.withParams(instance.getParams());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  
  public A addToParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParams(Collection<Param> items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Param> buildParams() {
    return this.params != null ? build(params) : null;
  }
  
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParams(List<Param> params) {
    if (this.params != null) {
      this._visitables.get("params").clear();
    }
    if (params != null) {
        this.params = new ArrayList();
        for (Param item : params) {
          this.addToParams(item);
        }
    } else {
      this.params = null;
    }
    return (A) this;
  }
  
  public A withParams(io.fabric8.tekton.pipeline.v1.Param... params) {
    if (this.params != null) {
        this.params.clear();
        _visitables.remove("params");
    }
    if (params != null) {
      for (Param item : params) {
        this.addToParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null && !this.params.isEmpty();
  }
  
  public ParamsNested<A> addNewParam() {
    return new ParamsNested(-1, null);
  }
  
  public ParamsNested<A> addNewParamLike(Param item) {
    return new ParamsNested(-1, item);
  }
  
  public ParamsNested<A> setNewParamLike(int index,Param item) {
    return new ParamsNested(index, item);
  }
  
  public ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  
  public ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IncludeParamsFluent that = (IncludeParamsFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  params,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParamsNested<N> extends ParamFluent<ParamsNested<N>> implements Nested<N>{
    ParamsNested(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamBuilder builder;
    int index;
    
    public N and() {
      return (N) IncludeParamsFluent.this.setToParams(index,builder.build());
    }
    
    public N endParam() {
      return and();
    }
    
  
  }

}