package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ParamSpecBuilder extends ParamSpecFluent<ParamSpecBuilder> implements VisitableBuilder<ParamSpec,ParamSpecBuilder>{
  public ParamSpecBuilder() {
    this(new ParamSpec());
  }
  
  public ParamSpecBuilder(ParamSpecFluent<?> fluent) {
    this(fluent, new ParamSpec());
  }
  
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ParamSpecBuilder(ParamSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ParamSpecFluent<?> fluent;
  
  public ParamSpec build() {
    ParamSpec buildable = new ParamSpec(fluent.buildDefault(),fluent.getDescription(),fluent.getName(),fluent.getProperties(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}