package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineTaskRunTemplateBuilder extends PipelineTaskRunTemplateFluent<PipelineTaskRunTemplateBuilder> implements VisitableBuilder<PipelineTaskRunTemplate,PipelineTaskRunTemplateBuilder>{
  public PipelineTaskRunTemplateBuilder() {
    this(new PipelineTaskRunTemplate());
  }
  
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent) {
    this(fluent, new PipelineTaskRunTemplate());
  }
  
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplateFluent<?> fluent,PipelineTaskRunTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineTaskRunTemplateBuilder(PipelineTaskRunTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineTaskRunTemplateFluent<?> fluent;
  
  public PipelineTaskRunTemplate build() {
    PipelineTaskRunTemplate buildable = new PipelineTaskRunTemplate(fluent.buildPodTemplate(),fluent.getServiceAccountName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}