package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkspaceBindingBuilder extends WorkspaceBindingFluent<WorkspaceBindingBuilder> implements VisitableBuilder<WorkspaceBinding,WorkspaceBindingBuilder>{
  public WorkspaceBindingBuilder() {
    this(new WorkspaceBinding());
  }
  
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent) {
    this(fluent, new WorkspaceBinding());
  }
  
  public WorkspaceBindingBuilder(WorkspaceBindingFluent<?> fluent,WorkspaceBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkspaceBindingBuilder(WorkspaceBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkspaceBindingFluent<?> fluent;
  
  public WorkspaceBinding build() {
    WorkspaceBinding buildable = new WorkspaceBinding(fluent.getConfigMap(),fluent.getCsi(),fluent.getEmptyDir(),fluent.getName(),fluent.getPersistentVolumeClaim(),fluent.getProjected(),fluent.getSecret(),fluent.getSubPath(),fluent.buildVolumeClaimTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}