/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1.TaskRunDebug;
import io.fabric8.tekton.pipeline.v1.TaskRunDebugFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskRunDebugFluentImpl<A extends TaskRunDebugFluent<A>>
extends BaseFluent<A>
implements TaskRunDebugFluent<A> {
    private List<String> breakpoint = new ArrayList<String>();

    public TaskRunDebugFluentImpl() {
    }

    public TaskRunDebugFluentImpl(TaskRunDebug instance) {
        if (instance != null) {
            this.withBreakpoint(instance.getBreakpoint());
        }
    }

    @Override
    public A addToBreakpoint(int index, String item) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        this.breakpoint.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBreakpoint(int index, String item) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        this.breakpoint.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBreakpoint(String ... items) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        for (String item : items) {
            this.breakpoint.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBreakpoint(Collection<String> items) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        for (String item : items) {
            this.breakpoint.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBreakpoint(String ... items) {
        for (String item : items) {
            if (this.breakpoint == null) continue;
            this.breakpoint.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBreakpoint(Collection<String> items) {
        for (String item : items) {
            if (this.breakpoint == null) continue;
            this.breakpoint.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public String getBreakpoint(int index) {
        return this.breakpoint.get(index);
    }

    @Override
    public String getFirstBreakpoint() {
        return this.breakpoint.get(0);
    }

    @Override
    public String getLastBreakpoint() {
        return this.breakpoint.get(this.breakpoint.size() - 1);
    }

    @Override
    public String getMatchingBreakpoint(Predicate<String> predicate) {
        for (String item : this.breakpoint) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBreakpoint(Predicate<String> predicate) {
        for (String item : this.breakpoint) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBreakpoint(List<String> breakpoint) {
        if (breakpoint != null) {
            this.breakpoint = new ArrayList<String>();
            for (String item : breakpoint) {
                this.addToBreakpoint(item);
            }
        } else {
            this.breakpoint = null;
        }
        return (A)this;
    }

    @Override
    public A withBreakpoint(String ... breakpoint) {
        if (this.breakpoint != null) {
            this.breakpoint.clear();
            this._visitables.remove((Object)"breakpoint");
        }
        if (breakpoint != null) {
            for (String item : breakpoint) {
                this.addToBreakpoint(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBreakpoint() {
        return this.breakpoint != null && !this.breakpoint.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunDebugFluentImpl that = (TaskRunDebugFluentImpl)o;
        return Objects.equals(this.breakpoint, that.breakpoint);
    }

    public int hashCode() {
        return Objects.hash(this.breakpoint, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.breakpoint != null && !this.breakpoint.isEmpty()) {
            sb.append("breakpoint:");
            sb.append(this.breakpoint);
        }
        sb.append("}");
        return sb.toString();
    }
}

